/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerManagementServer;
import com.nirima.jenkins.plugins.docker.Messages;
import com.nirima.jenkins.plugins.docker.PluginImpl;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.model.Saveable;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class DockerManagement
extends ManagementLink
implements StaplerProxy,
Describable<DockerManagement>,
Saveable {
    private static final Logger logger = LoggerFactory.getLogger(DockerManagement.class);

    public String getIconFileName() {
        return "/plugin/docker-plugin/images//48x48/docker.png";
    }

    public String getUrlName() {
        return "docker-plugin";
    }

    public String getDisplayName() {
        return Messages.DisplayName();
    }

    public String getDescription() {
        return Messages.PluginDescription();
    }

    public static DockerManagement get() {
        return (DockerManagement)((Object)ManagementLink.all().get(DockerManagement.class));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    public DockerManagementServer getServer(String serverName) {
        return new DockerManagementServer(serverName);
    }

    public Object getTarget() {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        return this;
    }

    public void save() throws IOException {
    }

    public Collection<String> getServerNames() {
        return Collections2.transform(PluginImpl.getInstance().getServers(), (Function)new Function<DockerCloud, String>(){

            public String apply(@Nullable DockerCloud input) {
                return input.getDisplayName();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<DockerManagement> {
        public String getDisplayName() {
            return null;
        }
    }
}

