/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerManagement;
import com.nirima.jenkins.plugins.docker.PluginImpl;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import javax.servlet.ServletException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockerManagementServer
implements Describable<DockerManagementServer> {
    final String name;
    final DockerCloud theCloud;

    public Descriptor<DockerManagementServer> getDescriptor() {
        return Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    public String getUrl() {
        return DockerManagement.get().getUrlName() + "/server/" + this.name;
    }

    public DockerManagementServer(String name) {
        this.name = name;
        this.theCloud = PluginImpl.getInstance().getServer(name);
    }

    public Collection getImages() {
        return this.theCloud.connect().images().finder().allImages(false).list();
    }

    public Collection getProcesses() {
        return this.theCloud.connect().containers().finder().allContainers(false).list();
    }

    public String asTime(Long time) {
        if (time == null) {
            return "";
        }
        long when = System.currentTimeMillis() - time;
        Date dt = new Date(when);
        return dt.toString();
    }

    public String getJsUrl(String jsName) {
        return "/plugin/docker-plugin/js/" + jsName;
    }

    public void doControlSubmit(@QueryParameter(value="stopId") String stopId, StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException, InterruptedException {
        this.theCloud.connect().container(stopId).stop();
        rsp.sendRedirect(".");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<DockerManagementServer> {
        public String getDisplayName() {
            return "server ";
        }
    }
}

