/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.nirima.jenkins.plugins.docker.DockerComputer;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import hudson.model.Descriptor;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockerRetentionStrategy
extends RetentionStrategy<DockerComputer> {
    private static final Logger LOGGER = Logger.getLogger(DockerRetentionStrategy.class.getName());
    public static boolean disabled = Boolean.getBoolean(DockerRetentionStrategy.class.getName() + ".disabled");

    @DataBoundConstructor
    public DockerRetentionStrategy() {
    }

    public synchronized long check(DockerComputer c) {
        long idleMilliseconds;
        LOGGER.log(Level.INFO, "Checking " + (Object)((Object)c));
        if (c.isIdle() && c.isOnline() && !disabled && c.haveWeRunAnyJobs() && (idleMilliseconds = System.currentTimeMillis() - c.getIdleStartMilliseconds()) > 0L) {
            LOGGER.info("Idle timeout: " + c.getName());
            LOGGER.log(Level.INFO, "Terminating " + (Object)((Object)c));
            try {
                ((DockerSlave)c.getNode()).retentionTerminate();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return 1L;
    }

    public void start(DockerComputer c) {
        c.connect(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return "Docker";
        }
    }
}

