/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.nirima.docker.client.DockerClient;
import com.nirima.docker.client.DockerException;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerComputer;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.action.DockerBuildAction;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockerSlave
extends AbstractCloudSlave {
    private static final Logger LOGGER = Logger.getLogger(DockerSlave.class.getName());
    public final DockerTemplate dockerTemplate;
    public final String containerId;
    private transient Run theRun;
    private transient boolean commitOnTermate;

    public DockerSlave(DockerTemplate dockerTemplate, String containerId, String name, String nodeDescription, String remoteFS, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, numExecutors, mode, labelString, launcher, retentionStrategy, nodeProperties);
        this.dockerTemplate = dockerTemplate;
        this.containerId = containerId;
    }

    public DockerCloud getCloud() {
        return this.dockerTemplate.getParent();
    }

    public String getDisplayName() {
        return this.name;
    }

    public void setRun(Run run) {
        this.theRun = run;
    }

    public void commitOnTerminate() {
        this.commitOnTermate = true;
    }

    public DockerComputer createComputer() {
        return new DockerComputer(this);
    }

    protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
        DockerClient client = this.getClient();
        try {
            this.toComputer().disconnect(null);
            client.container(this.containerId).stop();
            if (this.theRun != null) {
                try {
                    if (this.commitOnTermate) {
                        this.commit();
                    } else {
                        this.tag(null);
                    }
                }
                catch (DockerException e) {
                    LOGGER.log(Level.SEVERE, "Failure to commit instance " + this.containerId);
                }
            }
            client.container(this.containerId).remove();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failure to terminate instance " + this.containerId);
        }
    }

    public void commit() throws DockerException, IOException {
        DockerClient client = this.getClient();
        String tag_image = client.container(this.containerId).createCommitCommand().repo(this.theRun.getParent().getDisplayName()).tag(this.theRun.getDisplayName()).author("Jenkins").execute();
        this.tag(tag_image);
        try {
            if (!Strings.isNullOrEmpty((String)this.dockerTemplate.additionalTag)) {
                client.image(tag_image).tag(this.dockerTemplate.additionalTag, false);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Could not add additional tags");
        }
        if (this.dockerTemplate.push) {
            try {
                client.image(tag_image).push(null);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Could not push image");
            }
        }
    }

    private void tag(String tag_image) throws IOException {
        this.theRun.addAction((Action)new DockerBuildAction(this.getCloud().serverUrl, this.containerId, tag_image));
        this.theRun.save();
    }

    public DockerClient getClient() {
        return this.dockerTemplate.getParent().connect();
    }

    public void onConnected() {
    }

    public void retentionTerminate() throws IOException, InterruptedException {
        this.terminate();
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("containerId", (Object)this.containerId).toString();
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "Docker Slave";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

