/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserListBoxModel;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.nirima.docker.client.DockerClient;
import com.nirima.docker.client.DockerException;
import com.nirima.docker.client.model.ContainerConfig;
import com.nirima.docker.client.model.ContainerCreateResponse;
import com.nirima.docker.client.model.ContainerInspectResponse;
import com.nirima.docker.client.model.HostConfig;
import com.nirima.docker.client.model.PortBinding;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerComputerLauncher;
import com.nirima.jenkins.plugins.docker.DockerRetentionStrategy;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.trilead.ssh2.Connection;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockerTemplate
implements Describable<DockerTemplate> {
    private static final Logger LOGGER = Logger.getLogger(DockerTemplate.class.getName());
    public final String image;
    public final String labelString;
    public final String credentialsId;
    public final String jvmOptions;
    public final String javaPath;
    public final String prefixStartSlaveCmd;
    public final String suffixStartSlaveCmd;
    public final String remoteFs;
    public final int instanceCap;
    public final String[] dnsHosts;
    public final boolean tagOnCompletion;
    private transient Set<LabelAtom> labelSet;
    public transient DockerCloud parent;
    public final String additionalTag;
    public final boolean push;

    @DataBoundConstructor
    public DockerTemplate(String image, String labelString, String remoteFs, String credentialsId, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd, boolean tagOnCompletion, String instanceCapStr, String dnsString, String additionalTag, boolean push) {
        this.image = image;
        this.labelString = Util.fixNull((String)labelString);
        this.credentialsId = credentialsId;
        this.jvmOptions = jvmOptions;
        this.javaPath = javaPath;
        this.prefixStartSlaveCmd = prefixStartSlaveCmd;
        this.suffixStartSlaveCmd = suffixStartSlaveCmd;
        this.remoteFs = Strings.isNullOrEmpty((String)remoteFs) ? "/home/jenkins" : remoteFs;
        this.tagOnCompletion = tagOnCompletion;
        this.instanceCap = instanceCapStr.equals("") ? Integer.MAX_VALUE : Integer.parseInt(instanceCapStr);
        this.dnsHosts = dnsString.split(" ");
        this.additionalTag = additionalTag;
        this.push = push;
        this.readResolve();
    }

    public String getInstanceCapStr() {
        if (this.instanceCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    public String getDnsString() {
        return Joiner.on((String)" ").join((Object[])this.dnsHosts);
    }

    public Descriptor<DockerTemplate> getDescriptor() {
        return Jenkins.getInstance().getDescriptor(this.getClass());
    }

    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    protected Object readResolve() {
        this.labelSet = Label.parse((String)this.labelString);
        return this;
    }

    public String getDisplayName() {
        return "Image of " + this.image;
    }

    public DockerCloud getParent() {
        return this.parent;
    }

    public DockerSlave provision(StreamTaskListener listener) throws IOException, Descriptor.FormException, DockerException {
        PrintStream logger = listener.getLogger();
        logger.println("Launching " + this.image);
        String nodeDescription = "Docker Node";
        int numExecutors = 1;
        Node.Mode mode = Node.Mode.EXCLUSIVE;
        DockerRetentionStrategy retentionStrategy = new DockerRetentionStrategy();
        ArrayList nodeProperties = new ArrayList();
        ContainerInspectResponse containerInspectResponse = this.provisionNew();
        String containerId = containerInspectResponse.getId();
        DockerComputerLauncher launcher = new DockerComputerLauncher(this, containerInspectResponse);
        return new DockerSlave(this, containerId, containerId.substring(0, 12), nodeDescription, this.remoteFs, numExecutors, mode, this.labelString, launcher, retentionStrategy, nodeProperties);
    }

    public ContainerInspectResponse provisionNew() throws DockerException {
        DockerClient dockerClient = this.getParent().connect();
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setImage(this.image);
        containerConfig.setCmd(new String[]{"/usr/sbin/sshd", "-D"});
        containerConfig.setPortSpecs(new String[]{"22/tcp"});
        if (this.dnsHosts.length > 0) {
            containerConfig.setDns(this.dnsHosts);
        }
        ContainerCreateResponse container = dockerClient.containers().create(containerConfig);
        HashMap<String, PortBinding[]> bports = new HashMap<String, PortBinding[]>();
        PortBinding binding = new PortBinding();
        binding.hostIp = "0.0.0.0";
        bports.put("22/tcp", new PortBinding[]{binding});
        HostConfig hostConfig = new HostConfig();
        hostConfig.setPortBindings(bports);
        dockerClient.container(container.getId()).start(hostConfig);
        String containerId = container.getId();
        return dockerClient.container(containerId).inspect();
    }

    public int getNumExecutors() {
        return 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<DockerTemplate> {
        public String getDisplayName() {
            return "Docker Template";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
            return new SSHUserListBoxModel().withMatching(SSHAuthenticator.matcher(Connection.class), (Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{SSHLauncher.SSH_SCHEME}));
        }
    }
}

