/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import hudson.Plugin;
import hudson.slaves.Cloud;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginImpl
extends Plugin {
    private static final Logger logger = LoggerFactory.getLogger(PluginImpl.class);
    public static final String DISPLAY_NAME = "Docker Plugin";
    private static PluginImpl instance;
    public static final String DEFAULT_SERVER_NAME = "defaultServer";

    public PluginImpl() {
        instance = this;
    }

    public static PluginImpl getInstance() {
        return instance;
    }

    public synchronized Collection<DockerCloud> getServers() {
        Collection clouds = Collections2.filter((Collection)Jenkins.getInstance().clouds, (Predicate)new Predicate<Cloud>(){

            public boolean apply(@Nullable Cloud input) {
                return input instanceof DockerCloud;
            }
        });
        return clouds;
    }

    public DockerCloud getServer(final String serverName) {
        return (DockerCloud)((Object)Iterables.find(this.getServers(), (Predicate)new Predicate<DockerCloud>(){

            public boolean apply(@Nullable DockerCloud input) {
                return serverName.equals(input.getDisplayName());
            }
        }));
    }

    public void start() throws Exception {
        super.start();
    }

    public void load() throws IOException {
        super.load();
    }

    public void stop() throws Exception {
        super.stop();
    }
}

