/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.nirima.docker.client.DockerClient;
import com.nirima.docker.client.DockerException;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlCloudOption;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOptionDescriptor;
import hudson.Extension;
import hudson.model.AbstractBuild;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockerBuilderControlOptionProvisionAndStart
extends DockerBuilderControlCloudOption {
    private final String templateId;

    @DataBoundConstructor
    public DockerBuilderControlOptionProvisionAndStart(String cloudId, String templateId) {
        super(cloudId);
        this.templateId = templateId;
    }

    @Override
    public void execute(AbstractBuild<?, ?> build) throws DockerException {
        DockerTemplate template = this.getCloud(build).getTemplate(this.templateId);
        String containerId = template.provisionNew().getId();
        LOGGER.info("Starting container " + containerId);
        DockerClient client = this.getClient(build);
        client.container(containerId).start();
        this.getLaunchAction(build).started(client, containerId);
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends DockerBuilderControlOptionDescriptor {
        public String getDisplayName() {
            return "Provision & Start Container";
        }
    }
}

