/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.CertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.KeystoreSSLConfig;
import com.github.dockerjava.core.NameParser;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.jaxrs.DockerCmdExecFactoryImpl;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import shaded.com.google.common.base.Objects;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.base.Predicate;
import shaded.com.google.common.base.Strings;
import shaded.com.google.common.base.Throwables;
import shaded.com.google.common.collect.Collections2;
import shaded.com.google.common.collect.Iterables;

public class DockerCloud
extends Cloud {
    private static final Logger LOGGER = Logger.getLogger(DockerCloud.class.getName());
    public static final String CLOUD_ID_PREFIX = "docker-";
    private List<DockerTemplate> templates;
    public final String serverUrl;
    public final int containerCap;
    public final int connectTimeout;
    public final int readTimeout;
    public final String version;
    public final String credentialsId;
    private transient DockerClient connection;
    private static final HashMap<String, Integer> provisioningAmis = new HashMap();

    @DataBoundConstructor
    public DockerCloud(String name, List<? extends DockerTemplate> templates, String serverUrl, String containerCapStr, int connectTimeout, int readTimeout, String credentialsId, String version) {
        super(name);
        Preconditions.checkNotNull((Object)serverUrl);
        this.version = version;
        this.credentialsId = credentialsId;
        this.serverUrl = serverUrl;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.templates = templates != null ? new ArrayList<DockerTemplate>(templates) : Collections.emptyList();
        this.containerCap = containerCapStr.equals("") ? Integer.MAX_VALUE : Integer.parseInt(containerCapStr);
        this.readResolve();
    }

    public String getContainerCapStr() {
        if (this.containerCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.containerCap);
    }

    protected Object readResolve() {
        for (DockerTemplate t : this.templates) {
            t.parent = this;
        }
        return this;
    }

    public synchronized DockerClient connect() {
        if (this.connection == null) {
            this.connection = this.buildConnection();
        }
        return this.connection;
    }

    public DockerClientConfig getDockerClientConfig() {
        DockerClientConfig.DockerClientConfigBuilder config = DockerClientConfig.createDefaultConfigBuilder();
        config.withUri(this.serverUrl);
        if (!Strings.isNullOrEmpty((String)this.version)) {
            config.withVersion(this.version);
        }
        DockerCloud.addCredentials(config, this.credentialsId);
        if (this.readTimeout > 0) {
            config.withReadTimeout(Integer.valueOf(this.readTimeout * 1000));
        }
        return config.build();
    }

    private static void addCredentials(DockerClientConfig.DockerClientConfigBuilder config, String credentialsId) {
        if (!Strings.isNullOrEmpty((String)credentialsId)) {
            Credentials credentials = DockerCloud.lookupSystemCredentials(credentialsId);
            if (credentials instanceof CertificateCredentials) {
                CertificateCredentials certificateCredentials = (CertificateCredentials)credentials;
                config.withSSLConfig((SSLConfig)new KeystoreSSLConfig(certificateCredentials.getKeyStore(), certificateCredentials.getPassword().getPlainText()));
            } else if (credentials instanceof StandardUsernamePasswordCredentials) {
                StandardUsernamePasswordCredentials usernamePasswordCredentials = (StandardUsernamePasswordCredentials)credentials;
                config.withUsername(usernamePasswordCredentials.getUsername());
                config.withPassword(usernamePasswordCredentials.getPassword().getPlainText());
            }
        }
    }

    public static Credentials lookupSystemCredentials(String credentialsId) {
        return CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(Credentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    private DockerClient buildConnection() {
        LOGGER.log(Level.FINE, "Building connection to docker host \"{0}\" at: {1}", new Object[]{this.name, this.serverUrl});
        return DockerClientBuilder.getInstance((DockerClientConfig)this.getDockerClientConfig()).withDockerCmdExecFactory((DockerCmdExecFactory)new DockerCmdExecFactoryImpl()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementAmiSlaveProvision(String ami) {
        HashMap<String, Integer> hashMap = provisioningAmis;
        synchronized (hashMap) {
            int currentProvisioning;
            try {
                currentProvisioning = provisioningAmis.get(ami);
            }
            catch (NullPointerException npe) {
                return;
            }
            provisioningAmis.put(ami, Math.max(currentProvisioning - 1, 0));
        }
    }

    public synchronized Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        try {
            LOGGER.log(Level.INFO, "Asked to provision {0} slave(s) for: {1}", new Object[]{excessWorkload, label});
            ArrayList<NodeProvisioner.PlannedNode> r = new ArrayList<NodeProvisioner.PlannedNode>();
            List<DockerTemplate> templates = this.getTemplates(label);
            while (excessWorkload > 0 && !templates.isEmpty()) {
                DockerTemplate t;
                block6: {
                    t = templates.get(0);
                    LOGGER.log(Level.INFO, "Will provision \"{0}\" for: {1}", new Object[]{t.getImage(), label});
                    try {
                        if (!this.addProvisionedSlave(t)) {
                            templates.remove(t);
                        }
                        break block6;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Bad template {0}: {1}. Trying next template...", new Object[]{t.getImage(), e.getMessage()});
                        templates.remove(t);
                    }
                    continue;
                }
                r.add(new NodeProvisioner.PlannedNode(t.getDisplayName(), Computer.threadPoolForRemoting.submit(new Callable<Node>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Node call() throws Exception {
                        DockerSlave slave = null;
                        try {
                            slave = t.provision(new StreamTaskListener(System.out));
                            Jenkins jenkins = Jenkins.getInstance();
                            Object object = jenkins.getQueue();
                            synchronized (object) {
                                jenkins.addNode((Node)slave);
                            }
                            slave.toComputer().connect(false).get();
                            object = slave;
                            return object;
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.SEVERE, "Error in provisioning; slave=" + (Object)((Object)slave) + ", template=" + t);
                            ex.printStackTrace();
                            throw Throwables.propagate((Throwable)ex);
                        }
                        finally {
                            DockerCloud.this.decrementAmiSlaveProvision(t.getImage());
                        }
                    }
                }), t.getNumExecutors()));
                excessWorkload -= t.getNumExecutors();
            }
            return r;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while provisioning for: " + label, e);
            return Collections.emptyList();
        }
    }

    public boolean canProvision(Label label) {
        return this.getTemplate(label) != null;
    }

    @CheckForNull
    public DockerTemplate getTemplate(String template) {
        for (DockerTemplate t : this.templates) {
            if (!t.getImage().equals(template)) continue;
            return t;
        }
        return null;
    }

    @CheckForNull
    public DockerTemplate getTemplate(Label label) {
        List<DockerTemplate> templates = this.getTemplates(label);
        if (!templates.isEmpty()) {
            return templates.get(0);
        }
        return null;
    }

    public void addTemplate(DockerTemplate t) {
        t.parent = this;
        this.templates.add(t);
    }

    public List<DockerTemplate> getTemplates() {
        return this.templates;
    }

    public List<DockerTemplate> getTemplates(Label label) {
        ArrayList<DockerTemplate> dockerTemplates = new ArrayList<DockerTemplate>();
        for (DockerTemplate t : this.templates) {
            if (label == null && t.getMode() == Node.Mode.NORMAL) {
                dockerTemplates.add(t);
            }
            if (label == null || !label.matches(t.getLabelSet())) continue;
            dockerTemplates.add(t);
        }
        return dockerTemplates;
    }

    public void removeTemplate(DockerTemplate t) {
        this.templates.remove(t);
    }

    public int countCurrentDockerSlaves(String ami) throws Exception {
        final DockerClient dockerClient = this.connect();
        List containers = (List)dockerClient.listContainersCmd().exec();
        if (ami == null) {
            return containers.size();
        }
        List images = (List)dockerClient.listImagesCmd().exec();
        NameParser.ReposTag repostag = NameParser.parseRepositoryTag((String)ami);
        final String fullAmi = repostag.repos + ":" + (repostag.tag.isEmpty() ? "latest" : repostag.tag);
        boolean imageExists = Iterables.any((Iterable)images, (Predicate)new Predicate<Image>(){

            public boolean apply(Image image) {
                return Arrays.asList(image.getRepoTags()).contains(fullAmi);
            }
        });
        if (!imageExists) {
            LOGGER.log(Level.INFO, "Pulling image \"{0}\" since one was not found.  This may take awhile...", ami);
            try (InputStream imageStream = dockerClient.pullImageCmd(ami).exec();){
                int streamValue = 0;
                while (streamValue != -1) {
                    streamValue = imageStream.read();
                }
            }
            LOGGER.log(Level.INFO, "Finished pulling image \"{0}\"", ami);
        }
        final InspectImageResponse ir = dockerClient.inspectImageCmd(ami).exec();
        Collection matching = Collections2.filter((Collection)containers, (Predicate)new Predicate<Container>(){

            public boolean apply(@Nullable Container container) {
                InspectContainerResponse cis = dockerClient.inspectContainerCmd(container.getId()).exec();
                return cis.getImageId().equalsIgnoreCase(ir.getId());
            }
        });
        return matching.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean addProvisionedSlave(DockerTemplate t) throws Exception {
        String ami = t.getImage();
        int amiCap = t.instanceCap;
        int estimatedTotalSlaves = this.countCurrentDockerSlaves(null);
        int estimatedAmiSlaves = this.countCurrentDockerSlaves(ami);
        HashMap<String, Integer> hashMap = provisioningAmis;
        synchronized (hashMap) {
            int currentProvisioning;
            for (int amiCount : provisioningAmis.values()) {
                estimatedTotalSlaves += amiCount;
            }
            try {
                currentProvisioning = provisioningAmis.get(ami);
            }
            catch (NullPointerException npe) {
                currentProvisioning = 0;
            }
            estimatedAmiSlaves += currentProvisioning;
            if (estimatedTotalSlaves >= this.containerCap) {
                LOGGER.log(Level.INFO, "Not Provisioning \"{0}\"; Server \"{1}\" full with {2} container(s)", new Object[]{ami, this.name, this.containerCap});
                return false;
            }
            if (amiCap != 0 && estimatedAmiSlaves >= amiCap) {
                LOGGER.log(Level.INFO, "Not Provisioning \"{0}\"; Instance limit of {2} reached on server \"{1}\"", new Object[]{ami, this.name, amiCap});
                return false;
            }
            LOGGER.log(Level.INFO, "Provisioning \"{0}\" number {2} on \"{1}\"; Total containers: {3}", new Object[]{ami, this.name, estimatedAmiSlaves, estimatedTotalSlaves});
            provisioningAmis.put(ami, currentProvisioning + 1);
            return true;
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("name", (Object)this.name).add("serverUrl", (Object)this.serverUrl).toString();
    }

    public static class CredentialsListBoxModel
    extends AbstractIdCredentialsListBoxModel<CredentialsListBoxModel, StandardCertificateCredentials> {
        @NonNull
        protected String describe(@NonNull StandardCertificateCredentials c) {
            return CredentialsNameProvider.name((Credentials)c);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        public String getDisplayName() {
            return "Docker";
        }

        public FormValidation doTestConnection(@QueryParameter String serverUrl, @QueryParameter String credentialsId, @QueryParameter String version) throws IOException, ServletException, DockerException {
            try {
                URL url = new URL(serverUrl);
                DockerClientConfig.DockerClientConfigBuilder config = DockerClientConfig.createDefaultConfigBuilder().withUri(url.toString());
                if (!Strings.isNullOrEmpty((String)version)) {
                    config.withVersion(version);
                }
                DockerCloud.addCredentials(config, credentialsId);
                DockerClient dc = DockerClientBuilder.getInstance((DockerClientConfig)config.build()).withDockerCmdExecFactory((DockerCmdExecFactory)new DockerCmdExecFactoryImpl()).build();
                Version v = (Version)dc.versionCmd().exec();
                return FormValidation.ok((String)("Version = " + v.getVersion()));
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
            List credentials = CredentialsProvider.lookupCredentials(StandardCertificateCredentials.class, (ItemGroup)context);
            return new CredentialsListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.always(), (Iterable)credentials);
        }
    }
}

