/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.nirima.jenkins.plugins.docker.utils.Cacheable;
import hudson.model.Executor;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import shaded.com.google.common.base.Objects;

public class DockerComputer
extends AbstractCloudComputer<DockerSlave> {
    private static final Logger LOGGER = Logger.getLogger(DockerComputer.class.getName());
    private int checked = 0;
    private final Cacheable<Boolean> nodeExistenceStatus = new Cacheable<Boolean>(60000L, new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            return ((DockerSlave)DockerComputer.this.getNode()).containerExistsInCloud();
        }
    });

    public DockerComputer(DockerSlave dockerSlave) {
        super((AbstractCloudSlave)dockerSlave);
    }

    public DockerCloud getCloud() {
        return ((DockerSlave)this.getNode()).getCloud();
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
        super.taskAccepted(executor, task);
        LOGGER.log(Level.FINE, " Computer {0} taskAccepted", (Object)this);
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        Queue.Executable executable = executor.getCurrentExecutable();
        LOGGER.log(Level.FINE, " Computer {0} taskCompleted", (Object)this);
        if (executable instanceof Run) {
            Run build = (Run)executable;
            DockerSlave slave = (DockerSlave)this.getNode();
            if (slave == null) {
                LOGGER.log(Level.FINE, " Ignoring TaskCompleted for {0} as node has already been removed.", (Object)this);
            } else {
                slave.setRun(build);
            }
        }
        super.taskCompleted(executor, task, durationMS);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        super.taskCompletedWithProblems(executor, task, durationMS, problems);
        LOGGER.log(Level.FINE, " Computer {0} taskCompletedWithProblems", (Object)this);
    }

    public boolean isAcceptingTasks() {
        boolean result = super.isAcceptingTasks();
        if (!result) {
            return false;
        }
        this.updateAcceptingTasks();
        result = super.isAcceptingTasks();
        return result;
    }

    private void updateAcceptingTasks() {
        try {
            int pause = 5000;
            if (this.getOfflineCause() != null) {
                if (this.getOfflineCause().toString().contains("failed to launch the slave agent") && this.checked < 3) {
                    LOGGER.log(Level.INFO, "Slave agent not launched after checking " + this.checked + " time(s).  Waiting for any retries...");
                    ++this.checked;
                    Thread.sleep(pause);
                } else {
                    this.setAcceptingTasks(false);
                    LOGGER.log(Level.INFO, " Offline " + (Object)((Object)this) + " due to " + this.getOfflineCause());
                }
            } else if (!this.nodeExistenceStatus.get().booleanValue()) {
                this.setAcceptingTasks(false);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, " Computer " + (Object)((Object)this) + " error getting node");
            this.setAcceptingTasks(false);
        }
    }

    public void onConnected() {
        DockerSlave node = (DockerSlave)this.getNode();
        if (node != null) {
            node.onConnected();
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("name", (Object)super.getName()).add("slave", (Object)this.getNode()).toString();
    }
}

