/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.utils.PortUtils;
import com.nirima.jenkins.plugins.docker.utils.RetryingComputerLauncher;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DelegatingComputerLauncher;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import shaded.com.google.common.base.Preconditions;

public class DockerComputerLauncher
extends DelegatingComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(DockerComputerLauncher.class.getName());

    public DockerComputerLauncher(DockerTemplate template, InspectContainerResponse containerInspectResponse) {
        super(DockerComputerLauncher.makeLauncher(template, containerInspectResponse));
    }

    private static ComputerLauncher makeLauncher(DockerTemplate template, InspectContainerResponse containerInspectResponse) {
        SSHLauncher sshLauncher = DockerComputerLauncher.getSSHLauncher(containerInspectResponse, template);
        return new RetryingComputerLauncher((ComputerLauncher)sshLauncher);
    }

    private static SSHLauncher getSSHLauncher(InspectContainerResponse detail, DockerTemplate template) {
        Preconditions.checkNotNull((Object)template);
        Preconditions.checkNotNull((Object)detail);
        try {
            Ports.Binding[] bindings;
            ExposedPort sshPort = new ExposedPort(22);
            int port = 22;
            String host = null;
            for (Ports.Binding b : bindings = (Ports.Binding[])detail.getNetworkSettings().getPorts().getBindings().get(sshPort)) {
                port = b.getHostPort();
                host = b.getHostIp();
            }
            if (host == null || host.equals("0.0.0.0")) {
                URL hostUrl = new URL(template.getParent().serverUrl);
                host = hostUrl.getHost();
            }
            LOGGER.log(Level.INFO, "Creating slave SSH launcher for " + host + ":" + port);
            PortUtils.waitForPort(host, port);
            StandardUsernameCredentials credentials = SSHLauncher.lookupSystemCredentials((String)template.credentialsId);
            return new SSHLauncher(host, port, credentials, template.jvmOptions, template.javaPath, template.prefixStartSlaveCmd, template.suffixStartSlaveCmd, Integer.valueOf(template.getSSHLaunchTimeoutMinutes() * 60));
        }
        catch (NullPointerException ex) {
            throw new RuntimeException("No mapped port 22 in host for SSL. Config=" + detail);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL for host " + template);
        }
    }
}

