/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerException;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerComputer;
import com.nirima.jenkins.plugins.docker.DockerJobProperty;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.action.DockerBuildAction;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.model.queue.CauseOfBlockage;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import shaded.com.google.common.base.Objects;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.base.Strings;

public class DockerSlave
extends AbstractCloudSlave {
    private static final Logger LOGGER = Logger.getLogger(DockerSlave.class.getName());
    public final DockerTemplate dockerTemplate;
    public final String containerId;
    private transient Run theRun;

    @DataBoundConstructor
    public DockerSlave(DockerTemplate dockerTemplate, String containerId, String name, String nodeDescription, String remoteFS, int numExecutors, Node.Mode mode, Integer memoryLimit, Integer cpuShares, String labelString, ComputerLauncher launcher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, numExecutors, mode, labelString, launcher, retentionStrategy, nodeProperties);
        Preconditions.checkNotNull((Object)dockerTemplate);
        Preconditions.checkNotNull((Object)containerId);
        this.dockerTemplate = dockerTemplate;
        this.containerId = containerId;
    }

    public DockerCloud getCloud() {
        DockerCloud theCloud = this.dockerTemplate.getParent();
        if (theCloud == null) {
            throw new RuntimeException("Docker template " + this.dockerTemplate + " has no parent ");
        }
        return theCloud;
    }

    public String getDisplayName() {
        return this.name;
    }

    public void setRun(Run run) {
        this.theRun = run;
    }

    public DockerComputer createComputer() {
        return new DockerComputer(this);
    }

    public CauseOfBlockage canTake(Queue.BuildableItem item) {
        if (item.task instanceof Queue.FlyweightTask) {
            return new CauseOfBlockage(){

                public String getShortDescription() {
                    return "Don't run FlyweightTask on Docker node";
                }
            };
        }
        return super.canTake(item);
    }

    public boolean containerExistsInCloud() {
        try {
            DockerClient client = this.getClient();
            client.inspectContainerCmd(this.containerId).exec();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
        try {
            DockerClient client;
            this.toComputer().disconnect(null);
            try {
                client = this.getClient();
                client.stopContainerCmd(this.containerId).exec();
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to stop instance " + this.containerId + " for slave " + this.name + " due to exception", ex);
            }
            if (this.theRun != null) {
                try {
                    this.slaveShutdown(listener);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Failure to slaveShutdown instance " + this.containerId + " for slave " + this.name, e);
                }
            }
            try {
                client = this.getClient();
                client.removeContainerCmd(this.containerId).exec();
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to remove instance " + this.containerId + " for slave " + this.name + " due to exception", ex);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failure to terminate instance " + this.containerId + " for slave " + this.name, e);
        }
    }

    private void slaveShutdown(TaskListener listener) throws DockerException, IOException {
        if (!this.getJobProperty().tagOnCompletion) {
            this.addJenkinsAction(null);
            return;
        }
        DockerClient client = this.getClient();
        String tag_image = client.commitCmd(this.containerId).withRepository(this.theRun.getParent().getDisplayName()).withTag(this.theRun.getDisplayName().replace("#", "b")).withAuthor("Jenkins").exec();
        this.addJenkinsAction(tag_image);
        try {
            String tagToken = this.getAdditionalTag(listener);
            if (!Strings.isNullOrEmpty((String)tagToken)) {
                client.tagImageCmd(tag_image, null, tagToken).exec();
                this.addJenkinsAction(tagToken);
                if (this.getJobProperty().pushOnSuccess) {
                    client.pushImageCmd(tagToken).exec();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Could not add additional tags");
        }
        if (this.getJobProperty().cleanImages) {
            client.removeImageCmd(tag_image).withForce().exec();
        }
    }

    private String getAdditionalTag(TaskListener listener) {
        String tagToken = this.getJobProperty().additionalTag;
        try {
            if (!Strings.isNullOrEmpty((String)tagToken)) {
                tagToken = TokenMacro.expandAll((AbstractBuild)((AbstractBuild)this.theRun), (TaskListener)listener, (String)tagToken);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "can't expand macroses", e);
        }
        return tagToken;
    }

    private void addJenkinsAction(String tag_image) throws IOException {
        this.theRun.addAction((Action)new DockerBuildAction(this.getCloud().serverUrl, this.containerId, tag_image, this.dockerTemplate.remoteFsMapping));
        this.theRun.save();
    }

    public DockerClient getClient() {
        return this.getCloud().connect();
    }

    public void onConnected() {
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("name", (Object)this.name).add("containerId", (Object)this.containerId).add("template", (Object)this.dockerTemplate).toString();
    }

    private DockerJobProperty getJobProperty() {
        try {
            DockerJobProperty p = (DockerJobProperty)((AbstractBuild)this.theRun).getProject().getProperty(DockerJobProperty.class);
            if (p != null) {
                return p;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DockerJobProperty(false, null, false, true);
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "Docker Slave";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

