/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserListBoxModel;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerComputerLauncher;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.nirima.jenkins.plugins.docker.DockerTemplateBase;
import com.nirima.jenkins.plugins.docker.strategy.DockerOnceRetentionStrategy;
import com.trilead.ssh2.Connection;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.security.ACL;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.RetentionStrategy;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import shaded.com.google.common.base.Objects;
import shaded.com.google.common.base.Strings;
import shaded.com.google.common.collect.ImmutableList;

public class DockerTemplate
extends DockerTemplateBase
implements Describable<DockerTemplate> {
    private static final Logger LOGGER = Logger.getLogger(DockerTemplate.class.getName());
    public final String labelString;
    public final String credentialsId;
    public final String idleTerminationMinutes;
    public final String sshLaunchTimeoutMinutes;
    public final String jvmOptions;
    public final String javaPath;
    public final String prefixStartSlaveCmd;
    public final String suffixStartSlaveCmd;
    public final String remoteFsMapping;
    public String remoteFs = "/home/jenkins";
    public final int instanceCap;
    private Node.Mode mode = Node.Mode.NORMAL;
    private RetentionStrategy retentionStrategy = new DockerOnceRetentionStrategy(0);
    private transient Set<LabelAtom> labelSet;
    public transient DockerCloud parent;
    private int numExecutors = 1;

    @DataBoundConstructor
    public DockerTemplate(String image, String labelString, String remoteFs, String remoteFsMapping, String credentialsId, String idleTerminationMinutes, String sshLaunchTimeoutMinutes, String jvmOptions, String javaPath, Integer memoryLimit, Integer cpuShares, String prefixStartSlaveCmd, String suffixStartSlaveCmd, String instanceCapStr, String dnsString, String dockerCommand, String volumesString, String volumesFromString, String environmentsString, String lxcConfString, String hostname, String bindPorts, boolean bindAllPorts, boolean privileged, boolean tty, String macAddress) {
        super(image, dnsString, dockerCommand, volumesString, volumesFromString, environmentsString, lxcConfString, hostname, memoryLimit, cpuShares, (String)Objects.firstNonNull((Object)bindPorts, (Object)"0.0.0.0:22"), bindAllPorts, privileged, tty, macAddress);
        this.labelString = Util.fixNull((String)labelString);
        this.credentialsId = credentialsId;
        this.idleTerminationMinutes = idleTerminationMinutes;
        this.sshLaunchTimeoutMinutes = sshLaunchTimeoutMinutes;
        this.jvmOptions = jvmOptions;
        this.javaPath = javaPath;
        this.prefixStartSlaveCmd = prefixStartSlaveCmd;
        this.suffixStartSlaveCmd = suffixStartSlaveCmd;
        this.remoteFs = Strings.isNullOrEmpty((String)remoteFs) ? "/home/jenkins" : remoteFs;
        this.remoteFsMapping = remoteFsMapping;
        this.instanceCap = instanceCapStr.equals("") ? Integer.MAX_VALUE : Integer.parseInt(instanceCapStr);
        this.readResolve();
    }

    @DataBoundSetter
    public void setMode(Node.Mode mode) {
        this.mode = mode;
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    @DataBoundSetter
    public void setNumExecutors(int numExecutors) {
        this.numExecutors = numExecutors;
    }

    public int getNumExecutors() {
        if (this.getRetentionStrategy() instanceof DockerOnceRetentionStrategy) {
            return 1;
        }
        return this.numExecutors;
    }

    @DataBoundSetter
    public void setRetentionStrategy(RetentionStrategy retentionStrategy) {
        this.retentionStrategy = retentionStrategy;
    }

    public RetentionStrategy getRetentionStrategy() {
        return this.retentionStrategy;
    }

    public String getInstanceCapStr() {
        if (this.instanceCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    public String getRemoteFsMapping() {
        return this.remoteFsMapping;
    }

    public Descriptor<DockerTemplate> getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptor(this.getClass());
    }

    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    public int getSSHLaunchTimeoutMinutes() {
        if (this.sshLaunchTimeoutMinutes == null || this.sshLaunchTimeoutMinutes.trim().isEmpty()) {
            return 1;
        }
        try {
            return Integer.parseInt(this.sshLaunchTimeoutMinutes);
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.INFO, "Malformed SSH Launch Timeout value: {0}. Fallback to 1 min.", this.sshLaunchTimeoutMinutes);
            return 1;
        }
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.labelSet = Label.parse((String)this.labelString);
        return this;
    }

    public DockerCloud getParent() {
        return this.parent;
    }

    public int getIdleTerminationMinutes() {
        if (this.idleTerminationMinutes == null || this.idleTerminationMinutes.trim().isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(this.idleTerminationMinutes);
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.INFO, "Malformed idleTermination value: {0}. Fallback to 30.", this.idleTerminationMinutes);
            return 30;
        }
    }

    public DockerSlave provision(StreamTaskListener listener) throws IOException, Descriptor.FormException, DockerException {
        PrintStream logger = listener.getLogger();
        logger.println("Launching " + this.getImage());
        ArrayList nodeProperties = new ArrayList();
        String containerId = this.provisionNew();
        DockerClient client = this.getParent().connect();
        InspectContainerResponse containerInspectResponse = null;
        try {
            containerInspectResponse = client.inspectContainerCmd(containerId).exec();
        }
        catch (ProcessingException ex) {
            client.removeContainerCmd(containerId).withForce(true).exec();
            throw ex;
        }
        DockerComputerLauncher launcher = new DockerComputerLauncher(this, containerInspectResponse);
        String nodeDescription = "Docker Node [" + this.getImage() + " on ";
        try {
            nodeDescription = nodeDescription + this.getParent().getDisplayName();
        }
        catch (Exception ex) {
            nodeDescription = nodeDescription + "???";
        }
        nodeDescription = nodeDescription + "]";
        String slaveName = containerId.substring(0, 12);
        try {
            slaveName = slaveName + "@" + this.getParent().getDisplayName();
        }
        catch (Exception ex) {
            LOGGER.warning("Error fetching cloud name");
        }
        return new DockerSlave(this, containerId, slaveName, nodeDescription, this.remoteFs, this.getNumExecutors(), this.getMode(), this.memoryLimit, this.cpuShares, this.labelString, (ComputerLauncher)launcher, this.getRetentionStrategy(), nodeProperties);
    }

    public String provisionNew() throws DockerException {
        DockerClient dockerClient = this.getParent().connect();
        return this.provisionNew(dockerClient);
    }

    @Override
    public String[] getDockerCommandArray() {
        String[] cmd = super.getDockerCommandArray();
        if (cmd.length == 0) {
            cmd = new String[]{"/usr/sbin/sshd", "-D"};
        }
        return cmd;
    }

    @Override
    public Iterable<PortBinding> getPortMappings() {
        if (Strings.isNullOrEmpty((String)this.bindPorts)) {
            return ImmutableList.builder().add((Object)PortBinding.parse((String)"0.0.0.0::22")).build();
        }
        return super.getPortMappings();
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("image", (Object)this.getImage()).add("parent", (Object)this.parent).toString();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<DockerTemplate> {
        public FormValidation doCheckNumExecutors(@QueryParameter int numExecutors) {
            if (numExecutors > 1) {
                return FormValidation.warning((String)"Experimental, see help");
            }
            if (numExecutors < 1) {
                return FormValidation.error((String)"Must be > 0");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVolumesString(@QueryParameter String volumesString) {
            try {
                String[] strings;
                for (String s : strings = DockerTemplateBase.splitAndFilterEmpty(volumesString, "\n")) {
                    if (s.equals("/")) {
                        return FormValidation.error((String)"Invalid volume: path can't be '/'");
                    }
                    String[] group = s.split(":");
                    if (group.length > 3) {
                        return FormValidation.error((String)("Wrong syntax: " + s));
                    }
                    if (group.length == 2 || group.length == 3) {
                        if (group[1].equals("/")) {
                            return FormValidation.error((String)"Invalid bind mount: destination can't be '/'");
                        }
                        Bind.parse((String)s);
                        continue;
                    }
                    if (group.length == 1) {
                        new Volume(s);
                        continue;
                    }
                    return FormValidation.error((String)("Wrong line: " + s));
                }
            }
            catch (Throwable t) {
                return FormValidation.error((String)t.getMessage());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVolumesFromString(@QueryParameter String volumesFromString) {
            try {
                String[] strings;
                for (String volFrom : strings = DockerTemplateBase.splitAndFilterEmpty(volumesFromString, "\n")) {
                    VolumesFrom.parse((String)volFrom);
                }
            }
            catch (Throwable t) {
                return FormValidation.error((String)t.getMessage());
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return "Docker Template";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
            return new SSHUserListBoxModel().withMatching(SSHAuthenticator.matcher(Connection.class), (Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{SSHLauncher.SSH_SCHEME}));
        }
    }
}

