/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.NotModifiedException;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOptionDescriptor;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOptionStopStart;
import hudson.Extension;
import hudson.model.AbstractBuild;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerBuilderControlOptionStop
extends DockerBuilderControlOptionStopStart {
    public final boolean remove;

    @DataBoundConstructor
    public DockerBuilderControlOptionStop(String cloudName, String containerId, boolean remove) {
        super(cloudName, containerId);
        this.remove = remove;
    }

    @Override
    public void execute(AbstractBuild<?, ?> build) throws DockerException {
        LOGGER.info("Stopping container " + this.containerId);
        DockerClient client = this.getClient(build);
        try {
            client.stopContainerCmd(this.containerId).exec();
        }
        catch (NotModifiedException ex) {
            LOGGER.info("Already stopped.");
        }
        this.getLaunchAction(build).stopped(client, this.containerId);
        if (this.remove) {
            client.removeContainerCmd(this.containerId);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends DockerBuilderControlOptionDescriptor {
        public String getDisplayName() {
            return "Stop Container";
        }
    }
}

