/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.model.Identifier;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.jaxrs.DockerCmdExecFactoryImpl;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.nirima.jenkins.plugins.docker.action.DockerBuildImageAction;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import shaded.com.google.common.base.Optional;
import shaded.com.google.common.base.Throwables;

public class DockerBuilderPublisher
extends Builder
implements Serializable {
    public final String dockerFileDirectory;
    public final String tag;
    public final boolean pushOnSuccess;
    public final boolean cleanImages;
    public final boolean cleanupWithJenkinsJobDelete;

    @DataBoundConstructor
    public DockerBuilderPublisher(String dockerFileDirectory, String tag, boolean pushOnSuccess, boolean cleanImages, boolean cleanupWithJenkinsJobDelete) {
        this.dockerFileDirectory = dockerFileDirectory;
        this.tag = tag;
        this.pushOnSuccess = pushOnSuccess;
        this.cleanImages = cleanImages;
        this.cleanupWithJenkinsJobDelete = cleanupWithJenkinsJobDelete;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return new Run(build, launcher, listener).run();
    }

    private Optional<String> getImageId(String response) {
        for (String item : response.split("\n")) {
            if (!item.contains("Successfully built")) continue;
            String id = StringUtils.substringAfterLast((String)item, (String)"Successfully built ").trim();
            id = id.substring(0, 12);
            return Optional.of((Object)id);
        }
        return Optional.absent();
    }

    private DockerClient getDockerClient(AbstractBuild build) {
        Node node = build.getBuiltOn();
        if (node instanceof DockerSlave) {
            DockerSlave slave = (DockerSlave)node;
            return slave.getCloud().connect();
        }
        return null;
    }

    private DockerClientConfig getDockerClientConfig(AbstractBuild build) {
        Node node = build.getBuiltOn();
        if (node instanceof DockerSlave) {
            DockerSlave slave = (DockerSlave)node;
            return slave.getCloud().getDockerClientConfig();
        }
        return null;
    }

    private String getUrl(AbstractBuild build) {
        Node node = build.getBuiltOn();
        if (node instanceof DockerSlave) {
            DockerSlave slave = (DockerSlave)node;
            return slave.getCloud().serverUrl;
        }
        return null;
    }

    private String getTag(AbstractBuild build, Launcher launcher, BuildListener listener) {
        try {
            return TokenMacro.expandAll((AbstractBuild)build, (TaskListener)listener, (String)this.tag);
        }
        catch (Exception ex) {
            listener.getLogger().println("Couldn't macro expand tag " + this.tag);
            return this.tag;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Build / Publish Docker Containers";
        }
    }

    class Run
    implements Serializable {
        final transient AbstractBuild build;
        final transient Launcher launcher;
        final BuildListener listener;
        FilePath fpChild;
        final String tagToUse;
        final String url;
        final DockerClientConfig clientConfig;
        final transient DockerClient client;

        Run(AbstractBuild build, Launcher launcher, BuildListener listener) {
            this.build = build;
            this.launcher = launcher;
            this.listener = listener;
            this.fpChild = new FilePath(build.getWorkspace(), DockerBuilderPublisher.this.dockerFileDirectory);
            this.tagToUse = DockerBuilderPublisher.this.getTag(build, launcher, listener);
            this.url = DockerBuilderPublisher.this.getUrl(build);
            this.clientConfig = DockerBuilderPublisher.this.getDockerClientConfig(build);
            this.client = DockerBuilderPublisher.this.getDockerClient(build);
        }

        boolean run() throws IOException, InterruptedException {
            this.listener.getLogger().println("Docker Build");
            String response = this.buildImage();
            this.listener.getLogger().println("Docker Build Response : " + response);
            Optional id = DockerBuilderPublisher.this.getImageId(response);
            if (!id.isPresent()) {
                return false;
            }
            this.build.addAction((Action)new DockerBuildImageAction(this.url, (String)id.get(), this.tagToUse, DockerBuilderPublisher.this.cleanupWithJenkinsJobDelete, DockerBuilderPublisher.this.pushOnSuccess));
            this.build.save();
            if (DockerBuilderPublisher.this.pushOnSuccess) {
                this.listener.getLogger().println("Pushing " + this.tagToUse);
                String stringResponse = this.pushImage();
                this.listener.getLogger().println("Docker Push Response : " + stringResponse);
            }
            if (DockerBuilderPublisher.this.cleanImages) {
                this.listener.getLogger().println("Cleaning local images [" + (String)id.get() + "]");
                try {
                    this.cleanImages((String)id.get());
                }
                catch (Exception ex) {
                    this.listener.getLogger().println("Error attempting to clean images");
                }
            }
            this.listener.getLogger().println("Docker Build Done");
            return true;
        }

        private void cleanImages(String id) {
            this.client.removeImageCmd(id).withForce().exec();
        }

        private String buildImage() throws IOException, InterruptedException {
            return (String)this.fpChild.act((FilePath.FileCallable)new FilePath.FileCallable<String>(){

                public String invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                    try {
                        Run.this.listener.getLogger().println("Docker Build : build with tag " + Run.this.tagToUse + " at path " + f.getAbsolutePath());
                        DockerClient client = DockerClientBuilder.getInstance((DockerClientConfig)Run.this.clientConfig).withDockerCmdExecFactory((DockerCmdExecFactory)new DockerCmdExecFactoryImpl()).build();
                        InputStream is = (InputStream)client.buildImageCmd(f).withTag(Run.this.tagToUse).exec();
                        return IOUtils.toString((InputStream)is);
                    }
                    catch (DockerException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            });
        }

        private String pushImage() throws IOException {
            if (!this.tagToUse.toLowerCase().equals(this.tagToUse)) {
                this.listener.getLogger().println("ERROR: Docker will refuse to push tag name " + this.tagToUse + " because it uses upper case.");
            }
            Identifier identifier = Identifier.fromCompoundString((String)this.tagToUse);
            PushImageCmd pushImageCmd = this.client.pushImageCmd(identifier);
            PushImageCmd.Response pushResponse = pushImageCmd.exec();
            return IOUtils.toString((InputStream)pushResponse);
        }
    }
}

