/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.strategy;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.Queue;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.CloudRetentionStrategy;
import hudson.slaves.EphemeralNode;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.durabletask.executors.ContinuableExecutable;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerOnceRetentionStrategy
extends CloudRetentionStrategy
implements ExecutorListener {
    private static final Logger LOGGER = Logger.getLogger(DockerOnceRetentionStrategy.class.getName());
    private int idleMinutes = 0;

    @DataBoundConstructor
    public DockerOnceRetentionStrategy(int idleMinutes) {
        super(idleMinutes);
        this.idleMinutes = idleMinutes;
    }

    public int getIdleMinutes() {
        return this.idleMinutes;
    }

    public void start(AbstractCloudComputer c) {
        if (c.getNode() instanceof EphemeralNode) {
            throw new IllegalStateException("May not use DockerOnceRetentionStrategy on an EphemeralNode: " + c);
        }
        super.start(c);
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        this.done(executor);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        this.done(executor);
    }

    private void done(Executor executor) {
        AbstractCloudComputer c = (AbstractCloudComputer)executor.getOwner();
        Queue.Executable exec = executor.getCurrentExecutable();
        if (exec instanceof ContinuableExecutable && ((ContinuableExecutable)exec).willContinue()) {
            LOGGER.log(Level.FINE, "not terminating {0} because {1} says it will be continued", new Object[]{c.getName(), exec});
            return;
        }
        LOGGER.log(Level.FINE, "terminating {0} since {1} seems to be finished", new Object[]{c.getName(), exec});
        c.setAcceptingTasks(false);
        try {
            c.getNode().terminate();
        }
        catch (InterruptedException x) {
            LOGGER.log(Level.WARNING, null, x);
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
        }
    }

    public Descriptor<RetentionStrategy<?>> getDescriptor() {
        return super.getDescriptor();
    }

    @Extension(ordinal=200.0)
    public static final class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return "Docker Once Retention Strategy";
        }
    }
}

