/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.utils;

import java.util.Date;
import java.util.concurrent.Callable;

public class Cacheable<T> {
    final long timeout;
    final Callable<T> updateFunction;
    private T nodeExistenceStatus;
    private long nodeExistenceStatusTimestamp;

    public Cacheable(long timeout, Callable<T> updateFunction) {
        this.timeout = timeout;
        this.updateFunction = updateFunction;
    }

    public T get() throws Exception {
        if (this.expiredCheck()) {
            this.nodeExistenceStatus = this.updateFunction.call();
            this.nodeExistenceStatusTimestamp = new Date().getTime();
        }
        return this.nodeExistenceStatus;
    }

    private boolean expiredCheck() {
        return this.nodeExistenceStatusTimestamp + this.timeout < new Date().getTime();
    }
}

