/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.utils;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PortUtils {
    private static final int RETRIES = 10;
    private static final int WAIT_TIME_MS = 2000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortAvailable(String host, int port) {
        Socket socket = null;
        boolean available = false;
        try {
            socket = new Socket(host, port);
            available = true;
        }
        catch (IOException e) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
        return available;
    }

    public static boolean waitForPort(String host, int port) {
        for (int i = 0; i < 10; ++i) {
            if (PortUtils.isPortAvailable(host, port)) {
                return true;
            }
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    public static Map<String, List<Integer>> parsePorts(String waitPorts) throws IllegalArgumentException, NumberFormatException {
        String[] containerPorts;
        HashMap<String, List<Integer>> containers = new HashMap<String, List<Integer>>();
        for (String container : containerPorts = waitPorts.split(System.getProperty("line.separator"))) {
            Object[] idPorts = container.split(" ", 2);
            if (idPorts.length < 2) {
                throw new IllegalArgumentException("Cannot parse " + Arrays.toString(idPorts) + " as '[conainerId] [port1],[port2],...'");
            }
            String containerId = idPorts[0].trim();
            String portsStr = idPorts[1].trim();
            ArrayList<Integer> ports = new ArrayList<Integer>();
            for (String port : portsStr.split(",")) {
                ports.add(Integer.valueOf(port));
            }
            containers.put(containerId, ports);
        }
        return containers;
    }
}

