/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.utils;

import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DelegatingComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryingComputerLauncher
extends DelegatingComputerLauncher {
    private static final Logger log = LoggerFactory.getLogger(RetryingComputerLauncher.class);
    private final int pause = 5000;
    private boolean hasTried = false;

    public RetryingComputerLauncher(ComputerLauncher delegate) {
        super(delegate);
    }

    public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        if (this.hasTried) {
            log.info("Launch failed, pausing before retry.");
            Thread.sleep(5000L);
        }
        super.launch(computer, listener);
        this.hasTried = true;
    }
}

