/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.core.NameParser;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerImagePullStrategy;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.nirima.jenkins.plugins.docker.DockerTemplateBase;
import com.nirima.jenkins.plugins.docker.launcher.DockerComputerJNLPLauncher;
import com.nirima.jenkins.plugins.docker.launcher.DockerComputerLauncher;
import com.nirima.jenkins.plugins.docker.launcher.DockerComputerSSHLauncher;
import com.nirima.jenkins.plugins.docker.strategy.DockerOnceRetentionStrategy;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Saveable;
import hudson.model.labels.LabelAtom;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.slaves.RetentionStrategy;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import io.jenkins.docker.AttachedDockerSlaveProvisioner;
import io.jenkins.docker.DockerSlaveProvisioner;
import io.jenkins.docker.JNLPDockerSlaveProvisioner;
import io.jenkins.docker.SSHDockerSlaveProvisioner;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class DockerTemplate
implements Describable<DockerTemplate> {
    private static final Logger LOGGER = Logger.getLogger(DockerTemplate.class.getName());
    private int configVersion = 2;
    private final String labelString;
    private DockerComputerLauncher launcher;
    public final String remoteFsMapping;
    public String remoteFs = "/home/jenkins";
    public final int instanceCap;
    private Node.Mode mode = Node.Mode.NORMAL;
    private RetentionStrategy retentionStrategy = new DockerOnceRetentionStrategy(10);
    private int numExecutors = 1;
    private DockerTemplateBase dockerTemplateBase;
    private boolean removeVolumes;
    private transient Set<LabelAtom> labelSet;
    @CheckForNull
    private DockerImagePullStrategy pullStrategy = DockerImagePullStrategy.PULL_LATEST;
    private DescribableList<NodeProperty<?>, NodePropertyDescriptor> nodeProperties = new DescribableList((Saveable)Jenkins.getInstance());

    public DockerTemplate() {
        this.labelString = "";
        this.remoteFsMapping = Jenkins.getInstance().getRootDir().getAbsolutePath();
        this.instanceCap = 1;
    }

    @DataBoundConstructor
    public DockerTemplate(@Nonnull DockerTemplateBase dockerTemplateBase, String labelString, String remoteFs, String remoteFsMapping, String instanceCapStr, List<? extends NodeProperty<?>> nodeProperties) {
        this.dockerTemplateBase = dockerTemplateBase;
        this.labelString = Util.fixNull((String)labelString);
        this.remoteFs = Strings.isNullOrEmpty((String)remoteFs) ? "/home/jenkins" : remoteFs;
        this.remoteFsMapping = remoteFsMapping;
        this.instanceCap = instanceCapStr.equals("") ? Integer.MAX_VALUE : Integer.parseInt(instanceCapStr);
        this.labelSet = Label.parse((String)labelString);
        this.nodeProperties.clear();
        if (nodeProperties != null) {
            this.nodeProperties.addAll(nodeProperties);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public DockerTemplate(@Nonnull DockerTemplateBase dockerTemplateBase, String labelString, String remoteFs, String remoteFsMapping, String instanceCapStr, List<? extends NodeProperty<?>> nodeProperties, Node.Mode mode, int numExecutors, DockerComputerLauncher launcher, RetentionStrategy retentionStrategy, boolean removeVolumes, DockerImagePullStrategy pullStrategy) {
        this(dockerTemplateBase, labelString, remoteFs, remoteFsMapping, instanceCapStr, nodeProperties);
        this.setMode(mode);
        this.setNumExecutors(numExecutors);
        this.setLauncher(launcher);
        this.setRetentionStrategy(retentionStrategy);
        this.setRemoveVolumes(removeVolumes);
        this.setPullStrategy(pullStrategy);
    }

    public DockerSlaveProvisioner getProvisioner(DockerCloud cloud) {
        if (this.launcher instanceof DockerComputerJNLPLauncher) {
            return new JNLPDockerSlaveProvisioner(cloud, this, cloud.getClient(), (DockerComputerJNLPLauncher)this.launcher);
        }
        if (this.launcher instanceof DockerComputerSSHLauncher) {
            return new SSHDockerSlaveProvisioner(cloud, this, cloud.getClient(), (DockerComputerSSHLauncher)this.launcher);
        }
        return new AttachedDockerSlaveProvisioner(cloud, this, cloud.getClient());
    }

    public static String[] filterStringArray(String[] arr) {
        return DockerTemplateBase.filterStringArray(arr);
    }

    public String getImage() {
        return this.dockerTemplateBase.getImage();
    }

    public String getDnsString() {
        return this.dockerTemplateBase.getDnsString();
    }

    @CheckForNull
    public String[] getVolumes() {
        return this.dockerTemplateBase.getVolumes();
    }

    public String getVolumesString() {
        return this.dockerTemplateBase.getVolumesString();
    }

    @Deprecated
    public String getVolumesFrom() {
        return this.dockerTemplateBase.getVolumesFrom();
    }

    public String[] getVolumesFrom2() {
        return this.dockerTemplateBase.getVolumesFrom2();
    }

    public String getVolumesFromString() {
        return this.dockerTemplateBase.getVolumesFromString();
    }

    @CheckForNull
    public String getMacAddress() {
        return this.dockerTemplateBase.getMacAddress();
    }

    public String getDisplayName() {
        return this.dockerTemplateBase.getDisplayName();
    }

    public Integer getMemoryLimit() {
        return this.dockerTemplateBase.getMemoryLimit();
    }

    public Integer getMemorySwap() {
        return this.dockerTemplateBase.getMemorySwap();
    }

    public Integer getCpuShares() {
        return this.dockerTemplateBase.getCpuShares();
    }

    public String[] getDockerCommandArray() {
        return this.dockerTemplateBase.getDockerCommandArray();
    }

    public Iterable<PortBinding> getPortMappings() {
        return this.dockerTemplateBase.getPortMappings();
    }

    public String getEnvironmentsString() {
        return this.dockerTemplateBase.getEnvironmentsString();
    }

    @CheckForNull
    public List<String> getExtraHosts() {
        return this.dockerTemplateBase.getExtraHosts();
    }

    public String getExtraHostsString() {
        return this.dockerTemplateBase.getExtraHostsString();
    }

    public DockerRegistryEndpoint getRegistry() {
        return this.dockerTemplateBase.getRegistry();
    }

    public CreateContainerCmd fillContainerConfig(CreateContainerCmd containerConfig) {
        return this.dockerTemplateBase.fillContainerConfig(containerConfig);
    }

    public String getFullImageId() {
        NameParser.ReposTag repostag = NameParser.parseRepositoryTag((String)this.dockerTemplateBase.getImage());
        return repostag.repos + ":" + (repostag.tag.isEmpty() ? "latest" : repostag.tag);
    }

    public DockerTemplateBase getDockerTemplateBase() {
        return this.dockerTemplateBase;
    }

    public void setDockerTemplateBase(DockerTemplateBase dockerTemplateBase) {
        this.dockerTemplateBase = dockerTemplateBase;
    }

    public boolean isRemoveVolumes() {
        return this.removeVolumes;
    }

    @DataBoundSetter
    public void setRemoveVolumes(boolean removeVolumes) {
        this.removeVolumes = removeVolumes;
    }

    public String getLabelString() {
        return this.labelString;
    }

    @DataBoundSetter
    public void setMode(Node.Mode mode) {
        this.mode = mode;
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    @DataBoundSetter
    public void setNumExecutors(int numExecutors) {
        this.numExecutors = numExecutors;
    }

    public int getNumExecutors() {
        if (this.getRetentionStrategy() instanceof DockerOnceRetentionStrategy) {
            return 1;
        }
        return this.numExecutors;
    }

    @DataBoundSetter
    public void setRetentionStrategy(RetentionStrategy retentionStrategy) {
        this.retentionStrategy = retentionStrategy;
    }

    public RetentionStrategy getRetentionStrategy() {
        return this.retentionStrategy;
    }

    public RetentionStrategy getRetentionStrategyCopy() {
        if (this.retentionStrategy instanceof DockerOnceRetentionStrategy) {
            DockerOnceRetentionStrategy onceRetention = (DockerOnceRetentionStrategy)this.retentionStrategy;
            return new DockerOnceRetentionStrategy(onceRetention.getIdleMinutes());
        }
        return this.retentionStrategy;
    }

    @DataBoundSetter
    public void setLauncher(DockerComputerLauncher launcher) {
        this.launcher = launcher;
    }

    public DockerComputerLauncher getLauncher() {
        return this.launcher;
    }

    public String getRemoteFs() {
        return this.remoteFs;
    }

    public String getInstanceCapStr() {
        if (this.instanceCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    public String getRemoteFsMapping() {
        return this.remoteFsMapping;
    }

    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    public DockerImagePullStrategy getPullStrategy() {
        return this.pullStrategy;
    }

    @DataBoundSetter
    public void setPullStrategy(DockerImagePullStrategy pullStrategy) {
        this.pullStrategy = pullStrategy;
    }

    public List<? extends NodeProperty<?>> getNodeProperties() {
        return Collections.unmodifiableList(this.nodeProperties);
    }

    @DataBoundSetter
    public void setNodeProperties(List<? extends NodeProperty<?>> nodeProperties) throws IOException {
        this.nodeProperties.replaceBy(nodeProperties);
    }

    private void configDefaults() {
        if (this.mode == null) {
            this.mode = Node.Mode.NORMAL;
        }
        if (this.retentionStrategy == null) {
            this.retentionStrategy = new DockerOnceRetentionStrategy(10);
        }
        if (this.pullStrategy == null) {
            this.pullStrategy = DockerImagePullStrategy.PULL_LATEST;
        }
        if (this.nodeProperties == null) {
            this.nodeProperties = new DescribableList((Saveable)Jenkins.getInstance());
        }
    }

    public Object readResolve() {
        try {
            if (this.configVersion < 2) {
                DockerOnceRetentionStrategy tmpStrategy;
                if (this.retentionStrategy instanceof DockerOnceRetentionStrategy && (tmpStrategy = (DockerOnceRetentionStrategy)this.retentionStrategy).getIdleMinutes() == 0) {
                    this.setRetentionStrategy((RetentionStrategy)new DockerOnceRetentionStrategy(10));
                }
                this.configVersion = 2;
            } else {
                this.configDefaults();
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Can't convert old values to new (double conversion?): ", t);
        }
        try {
            this.labelSet = Label.parse((String)this.labelString);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Can't parse labels: ", t);
        }
        return this;
    }

    public String toString() {
        return "DockerTemplate{configVersion=" + this.configVersion + ", labelString='" + this.labelString + '\'' + ", launcher=" + (Object)((Object)this.launcher) + ", remoteFsMapping='" + this.remoteFsMapping + '\'' + ", remoteFs='" + this.remoteFs + '\'' + ", instanceCap=" + this.instanceCap + ", mode=" + this.mode + ", retentionStrategy=" + this.retentionStrategy + ", numExecutors=" + this.numExecutors + ", dockerTemplateBase=" + this.dockerTemplateBase + ", removeVolumes=" + this.removeVolumes + ", pullStrategy=" + (Object)((Object)this.pullStrategy) + ", nodeProperties=" + this.nodeProperties + '}';
    }

    public String getShortDescription() {
        return Objects.toStringHelper((Object)this).add("image", (Object)this.dockerTemplateBase.getImage()).toString();
    }

    public Descriptor<DockerTemplate> getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptor(this.getClass());
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<DockerTemplate> {
        public FormValidation doCheckNumExecutors(@QueryParameter int numExecutors) {
            if (numExecutors > 1) {
                return FormValidation.warning((String)"Experimental, see help");
            }
            if (numExecutors < 1) {
                return FormValidation.error((String)"Must be > 0");
            }
            return FormValidation.ok();
        }

        public List<NodePropertyDescriptor> getNodePropertyDescriptors() {
            DockerSlave.DescriptorImpl descriptor = (DockerSlave.DescriptorImpl)Jenkins.getInstance().getDescriptorOrDie(DockerSlave.class);
            return descriptor.nodePropertyDescriptors(null);
        }

        public String getDisplayName() {
            return "Docker Template";
        }

        public Class getDockerTemplateBase() {
            return DockerTemplateBase.class;
        }
    }
}

