/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.utils;

import com.google.common.base.Preconditions;
import com.trilead.ssh2.Connection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortUtils.class);

    public static ConnectionCheck connectionCheck(String host, int port) {
        return new ConnectionCheck(host, port);
    }

    public static ConnectionCheck connectionCheck(InetSocketAddress address) {
        return new ConnectionCheck(address.getHostString(), address.getPort());
    }

    public static class ConnectionCheckSSH {
        private final ConnectionCheck parent;
        private int sshTimeoutMillis = (int)TimeUnit.SECONDS.toMillis(2L);

        ConnectionCheckSSH(ConnectionCheck connectionCheck) {
            this.parent = connectionCheck;
        }

        public ConnectionCheckSSH withSSHTimeout(int time, TimeUnit units) {
            this.sshTimeoutMillis = (int)units.toMillis(time);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean execute() {
            Preconditions.checkState((boolean)this.parent.execute(), (String)"Port %s is not opened to connect to", (Object[])new Object[]{this.parent.port});
            for (int i = 1; i <= this.parent.retries; ++i) {
                try (Connection connection = new Connection(this.parent.host, this.parent.port);){
                    connection.connect(null, 0, this.sshTimeoutMillis, this.sshTimeoutMillis);
                    LOGGER.info("SSH port is open on {}:{}", (Object)this.parent.host, (Object)this.parent.port);
                    boolean bl = true;
                    return bl;
                }
                try {
                    Thread.sleep(this.parent.retryDelay);
                    continue;
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ConnectionCheck {
        private final String host;
        private final int port;
        private int retries = 10;
        private long retryDelay = TimeUnit.SECONDS.toMillis(2L);

        private ConnectionCheck(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public ConnectionCheck withRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public ConnectionCheck withEveryRetryWaitFor(int time, TimeUnit units) {
            this.retryDelay = units.toMillis(time);
            return this;
        }

        public ConnectionCheckSSH useSSH() {
            return new ConnectionCheckSSH(this);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean executeOnce() {
            try (Socket ignored = new Socket(this.host, this.port);){
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                return false;
            }
        }

        public boolean execute() {
            LOGGER.trace("Testing connectivity to {} port {}", (Object)this.host, (Object)this.port);
            for (int i = 1; i <= this.retries; ++i) {
                if (this.executeOnce()) {
                    return true;
                }
                try {
                    Thread.sleep(this.retryDelay);
                    continue;
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            LOGGER.warn("Could not connect to {} port {}. Are you sure this location is contactable from Jenkins?", (Object)this.host, (Object)this.port);
            return false;
        }
    }
}

