/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.command.AttachContainerResultCallback;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerComputer;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.launcher.DockerComputerJNLPLauncher;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.Which;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.JNLPLauncher;
import io.jenkins.docker.DockerSlaveProvisioner;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JNLPDockerSlaveProvisioner
extends DockerSlaveProvisioner {
    private static final Logger LOGGER = LoggerFactory.getLogger(JNLPDockerSlaveProvisioner.class);
    private final DockerComputerJNLPLauncher launcher;
    private File remoting;
    private DockerSlave slave;

    public JNLPDockerSlaveProvisioner(DockerCloud cloud, DockerTemplate template, DockerClient client, DockerComputerJNLPLauncher launcher) {
        super(cloud, template, client);
        this.launcher = launcher;
    }

    @Override
    public DockerSlave provision() throws IOException, Descriptor.FormException, InterruptedException {
        this.slave = new DockerSlave(this.cloud, this.template, (ComputerLauncher)this.launcher.getJnlpLauncher());
        Jenkins.getActiveInstance().addNode((Node)this.slave);
        this.remoting = Which.jarFile(Channel.class);
        String id = this.runContainer();
        this.slave.getComputer().setContainerId(id);
        InspectContainerResponse inspect = this.client.inspectContainerCmd(this.container).exec();
        if ("exited".equals(inspect.getState().getStatus())) {
            LOGGER.error("Failed to launch docker JNLP agent :" + inspect.getState().getExitCode());
        }
        return this.slave;
    }

    @Override
    protected void prepareCreateContainerCommand(CreateContainerCmd cmd) throws DockerException, IOException {
        DockerComputer computer = this.slave.getComputer();
        if (computer == null) {
            throw new IllegalStateException("DockerSlave hasn't been registered as an active Node");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("java");
        JNLPLauncher jnlpLauncher = this.launcher.getJnlpLauncher();
        String vmargs = jnlpLauncher.vmargs;
        if (StringUtils.isNotBlank((String)vmargs)) {
            args.addAll(Arrays.asList(vmargs.split(" ")));
        }
        args.addAll(Arrays.asList("-cp", this.template.remoteFs + "/" + this.remoting.getName(), "hudson.remoting.jnlp.Main", "-headless"));
        if (StringUtils.isNotBlank((String)jnlpLauncher.tunnel)) {
            args.addAll(Arrays.asList("--tunnel", jnlpLauncher.tunnel));
        }
        args.addAll(Arrays.asList("-url", Jenkins.getInstance().getRootUrl(), computer.getJnlpMac(), computer.getName()));
        cmd.withCmd(args);
    }

    @Override
    protected void setupContainer() throws DockerException, IOException {
        this.client.copyArchiveToContainerCmd(this.container).withHostResource(this.remoting.getAbsolutePath()).withRemotePath(this.template.remoteFs).exec();
        final TaskListener listener = TaskListener.NULL;
        this.client.attachContainerCmd(this.container).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withLogs(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).exec((ResultCallback)new AttachContainerResultCallback(){

            public void onNext(Frame item) {
                switch (item.getStreamType()) {
                    case STDOUT: 
                    case STDERR: {
                        String log = new String(item.getPayload(), StandardCharsets.UTF_8);
                        listener.getLogger().append(log);
                        System.out.printf(log, new Object[0]);
                    }
                }
            }
        });
    }
}

