/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerComputer;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.launcher.DockerComputerSSHLauncher;
import com.trilead.ssh2.signature.RSAPublicKey;
import com.trilead.ssh2.signature.RSASHA1Verify;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.plugins.sshslaves.SSHConnector;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.remoting.Base64;
import hudson.slaves.ComputerLauncher;
import io.jenkins.docker.DockerSlaveProvisioner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.security.Key;
import jenkins.bouncycastle.api.PEMEncodable;
import jenkins.model.Jenkins;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHDockerSlaveProvisioner
extends DockerSlaveProvisioner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSHDockerSlaveProvisioner.class);
    private final DockerComputerSSHLauncher launcher;
    private DockerSlave slave;

    public SSHDockerSlaveProvisioner(DockerCloud cloud, DockerTemplate template, DockerClient client, DockerComputerSSHLauncher launcher) {
        super(cloud, template, client);
        this.launcher = launcher;
    }

    @Override
    public DockerSlave provision() throws IOException, Descriptor.FormException, InterruptedException {
        String id = this.runContainer();
        InspectContainerResponse inspect = this.client.inspectContainerCmd(this.container).exec();
        if ("exited".equals(inspect.getState().getStatus())) {
            LOGGER.error("Failed to launch docker SSH agent :" + inspect.getState().getExitCode());
        }
        StandardUsernameCredentials pk = this.getPrivateKeyAsCredentials();
        InetSocketAddress address = this.launcher.getAddressForSSHD(this.cloud, inspect);
        SSHConnector sshConnector = this.launcher.getSshConnector();
        SSHLauncher ssh = new SSHLauncher(address.getHostString(), address.getPort(), pk, sshConnector.jvmOptions, sshConnector.javaPath, sshConnector.prefixStartSlaveCmd, sshConnector.suffixStartSlaveCmd, sshConnector.launchTimeoutSeconds);
        this.slave = new DockerSlave(this.cloud, this.template, (ComputerLauncher)ssh);
        Jenkins.getActiveInstance().addNode((Node)this.slave);
        DockerComputer computer = this.slave.getComputer();
        if (computer != null) {
            computer.setContainerId(id);
        }
        return this.slave;
    }

    private StandardUsernameCredentials getPrivateKeyAsCredentials() throws IOException {
        if (!this.launcher.isUseSSHkey()) {
            return this.launcher.getSshConnector().getCredentials();
        }
        InstanceIdentity id = InstanceIdentity.get();
        String pem = PEMEncodable.create((Key)id.getPrivate()).encode();
        return new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, "InstanceIdentity", "root", (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(pem), null, "private key for docker ssh agent");
    }

    @Override
    protected void prepareCreateContainerCommand(CreateContainerCmd cmd) throws DockerException, IOException {
        int sshPort = this.launcher.getSshConnector().port;
        if (cmd.getCmd() == null || cmd.getCmd().length == 0) {
            if (this.launcher.isUseSSHkey()) {
                cmd.withCmd(new String[]{"/usr/sbin/sshd", "-D", "-p", String.valueOf(sshPort), "-o", "AuthorizedKeysCommand /root/authorized_key", "-o", "AuthorizedKeysCommandUser root"});
            } else {
                cmd.withCmd(new String[]{"/usr/sbin/sshd", "-D", "-p", String.valueOf(sshPort)});
            }
        }
        cmd.withPortSpecs(new String[]{sshPort + "/tcp"});
        cmd.withPortBindings(new PortBinding[]{PortBinding.parse((String)(":" + sshPort))});
        cmd.withExposedPorts(new ExposedPort[]{ExposedPort.parse((String)(sshPort + "/tcp"))});
    }

    @Override
    protected void setupContainer() throws IOException {
        if (this.launcher.isUseSSHkey()) {
            InstanceIdentity id = InstanceIdentity.get();
            java.security.interfaces.RSAPublicKey rsa = id.getPublic();
            String AuthorizedKeysCommand = "#!/bin/sh\necho 'ssh-rsa " + Base64.encode((byte[])RSASHA1Verify.encodeSSHRSAPublicKey((RSAPublicKey)new RSAPublicKey(rsa.getPublicExponent(), rsa.getModulus()))) + "'";
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                 TarArchiveOutputStream tar = new TarArchiveOutputStream((OutputStream)bos);){
                TarArchiveEntry entry = new TarArchiveEntry("authorized_key");
                entry.setSize((long)AuthorizedKeysCommand.getBytes().length);
                entry.setMode(448);
                tar.putArchiveEntry((ArchiveEntry)entry);
                tar.write(AuthorizedKeysCommand.getBytes());
                tar.closeArchiveEntry();
                tar.close();
                try (ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());){
                    this.client.copyArchiveToContainerCmd(this.container).withTarInputStream((InputStream)is).withRemotePath("/root").exec();
                }
            }
        }
    }
}

