/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.google.common.base.Objects;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import hudson.model.Executor;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DockerComputer
extends AbstractCloudComputer<DockerSlave> {
    private static final Logger LOGGER = Logger.getLogger(DockerComputer.class.getName());

    public DockerComputer(DockerSlave dockerSlave) {
        super((AbstractCloudSlave)dockerSlave);
    }

    public DockerCloud getCloud() {
        return ((DockerSlave)this.getNode()).getCloud();
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
        super.taskAccepted(executor, task);
        LOGGER.log(Level.FINE, " Computer {0} taskAccepted", (Object)this);
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        Queue.Executable executable = executor.getCurrentExecutable();
        LOGGER.log(Level.FINE, " Computer {0} taskCompleted", (Object)this);
        if (executable instanceof Run) {
            Run build = (Run)executable;
            DockerSlave slave = (DockerSlave)this.getNode();
            if (slave == null) {
                LOGGER.log(Level.FINE, " Ignoring TaskCompleted for {0} as node has already been removed.", (Object)this);
            } else {
                slave.setRun(build);
            }
        }
        super.taskCompleted(executor, task, durationMS);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        super.taskCompletedWithProblems(executor, task, durationMS, problems);
        LOGGER.log(Level.FINE, " Computer {0} taskCompletedWithProblems", (Object)this);
    }

    public String getContainerId() {
        return ((DockerSlave)this.getNode()).getContainerId();
    }

    public String getCloudId() {
        return ((DockerSlave)this.getNode()).getCloudId();
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("name", (Object)super.getName()).add("slave", (Object)this.getNode()).toString();
    }
}

