/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.NotFoundException;

public enum DockerImagePullStrategy {
    PULL_ALWAYS("Pull all images every time"){

        @Override
        public boolean pullIfNotExists(String imageName) {
            return true;
        }

        @Override
        public boolean pullIfExists(String imageName) {
            return true;
        }
    }
    ,
    PULL_LATEST("Pull once and update latest"){

        @Override
        public boolean pullIfNotExists(String imageName) {
            return true;
        }

        @Override
        public boolean pullIfExists(String imageName) {
            return imageName.endsWith(":latest");
        }
    }
    ,
    PULL_NEVER("Never pull"){

        @Override
        public boolean pullIfNotExists(String imageName) {
            return false;
        }

        @Override
        public boolean pullIfExists(String imageName) {
            return false;
        }
    };

    private final String description;

    private DockerImagePullStrategy(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract boolean pullIfNotExists(String var1);

    public abstract boolean pullIfExists(String var1);

    public boolean shouldPullImage(DockerClient client, String image) {
        boolean imageExists;
        if (this.pullIfExists(image) && this.pullIfNotExists(image)) {
            return true;
        }
        if (!this.pullIfExists(image) && !this.pullIfNotExists(image)) {
            return false;
        }
        try {
            client.inspectImageCmd(image).exec();
            imageExists = true;
        }
        catch (NotFoundException e) {
            imageExists = false;
        }
        return imageExists ? this.pullIfExists(image) : this.pullIfNotExists(image);
    }
}

