/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.DockerException;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlCloudOption;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOption;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.PrintStream;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerBuilderControlOptionProvisionAndStart
extends DockerBuilderControlCloudOption {
    private static final Logger LOG = LoggerFactory.getLogger(DockerBuilderControlOptionProvisionAndStart.class);
    private final String templateId;

    @DataBoundConstructor
    public DockerBuilderControlOptionProvisionAndStart(String cloudName, String templateId) {
        super(cloudName);
        this.templateId = templateId;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    @Override
    public void execute(Run<?, ?> build, Launcher launcher, TaskListener listener) throws DockerException {
        PrintStream llog = listener.getLogger();
        DockerCloud cloud = this.getCloud(build, launcher);
        DockerTemplate template = cloud.getTemplate(this.templateId);
        DockerClient client = cloud.getClient();
        String containerId = DockerCloud.runContainer(template.getDockerTemplateBase(), client);
        LOG.info("Starting container {}, cloud {}", (Object)containerId, (Object)cloud.getDisplayName());
        llog.println("Starting container " + containerId + ", cloud " + cloud.getDisplayName());
        this.getLaunchAction(build).started(client, containerId);
    }

    @Extension
    public static final class DescriptorImpl
    extends DockerBuilderControlOption.DockerBuilderControlOptionDescriptor {
        public String getDisplayName() {
            return "Provision & Start Container";
        }
    }
}

