/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.builder;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.exception.DockerException;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOption;
import com.nirima.jenkins.plugins.docker.builder.DockerBuilderControlOptionStopStart;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerBuilderControlOptionStart
extends DockerBuilderControlOptionStopStart {
    private static final Logger LOG = LoggerFactory.getLogger(DockerBuilderControlOptionStart.class);

    @DataBoundConstructor
    public DockerBuilderControlOptionStart(String cloudName, String containerId) {
        super(cloudName, containerId);
    }

    @Override
    public void execute(Run<?, ?> build, Launcher launcher, TaskListener listener) throws DockerException {
        LOG.info("Starting container {}", (Object)this.containerId);
        listener.getLogger().println("Starting container " + this.containerId);
        DockerClient client = this.getCloud(build, launcher).getClient();
        client.startContainerCmd(this.containerId).exec();
        this.getLaunchAction(build).started(client, this.containerId);
    }

    @Extension
    public static final class DescriptorImpl
    extends DockerBuilderControlOption.DockerBuilderControlOptionDescriptor {
        public String getDisplayName() {
            return "Start Container";
        }
    }
}

