/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.connector;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.command.AttachContainerResultCallback;
import com.google.common.base.Throwables;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import io.jenkins.docker.connector.DockerComputerConnector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DockerComputerAttachConnector
extends DockerComputerConnector {
    private String user;

    @DataBoundConstructor
    public DockerComputerAttachConnector() {
    }

    public String getUser() {
        return this.user;
    }

    @DataBoundSetter
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public void beforeContainerCreated(DockerCloud cloud, DockerTemplate template, CreateContainerCmd cmd) throws IOException, InterruptedException {
        this.ensureWaiting(cmd);
    }

    @Override
    public void afterContainerStarted(DockerCloud cloud, DockerTemplate template, String containerId) throws IOException, InterruptedException {
        DockerClient client = cloud.getClient();
        this.injectRemotingJar(containerId, template.remoteFs, client);
    }

    @Override
    protected ComputerLauncher launch(DockerCloud cloud, DockerTemplate template, InspectContainerResponse inspect, TaskListener listener) throws IOException, InterruptedException {
        return new DockerAttachLauncher(cloud, inspect.getId(), this.user, template.remoteFs);
    }

    private static class DockerAttachLauncher
    extends ComputerLauncher {
        private final String cloudName;
        private final String containerId;
        private final String user;
        private final String remoteFs;

        private DockerAttachLauncher(DockerCloud cloud, String containerId, String user, String remoteFs) {
            this.cloudName = cloud.name;
            this.containerId = containerId;
            this.user = user;
            this.remoteFs = remoteFs;
        }

        public void launch(final SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
            DockerCloud cloud = DockerCloud.getCloudByName(this.cloudName);
            DockerClient client = cloud.getClient();
            computer.getListener().getLogger().println("Connecting to docker container " + this.containerId);
            ExecCreateCmd cmd = client.execCreateCmd(this.containerId).withAttachStdin(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withTty(Boolean.valueOf(false)).withCmd(new String[]{"java", "-jar", this.remoteFs + '/' + DockerComputerConnector.remoting.getName()});
            if (StringUtils.isNotBlank((String)this.user)) {
                cmd.withUser(this.user);
            }
            ExecCreateCmdResponse exec = (ExecCreateCmdResponse)cmd.exec();
            PipedInputStream containerStdin = new PipedInputStream();
            PipedOutputStream out = new PipedOutputStream(containerStdin);
            final PipedOutputStream containerStdout = new PipedOutputStream();
            PipedInputStream in = new PipedInputStream(containerStdout);
            final AttachContainerResultCallback callback = new AttachContainerResultCallback(){

                public void onNext(Frame item) {
                    switch (item.getStreamType()) {
                        case STDERR: {
                            computer.getListener().error(new String(item.getPayload(), StandardCharsets.UTF_8));
                            break;
                        }
                        case STDOUT: 
                        case RAW: {
                            try {
                                containerStdout.write(item.getPayload());
                                break;
                            }
                            catch (IOException e) {
                                throw new DockerException("Failed to collect stdout", 0, (Throwable)e);
                            }
                        }
                    }
                }
            };
            client.execStartCmd(exec.getId()).withStdIn((InputStream)containerStdin).exec((ResultCallback)callback);
            computer.setChannel((InputStream)in, (OutputStream)out, computer.getListener(), new Channel.Listener(){

                public void onClosed(Channel channel, IOException cause) {
                    try {
                        callback.close();
                    }
                    catch (IOException e) {
                        Throwables.propagate((Throwable)e);
                    }
                }
            });
        }
    }

    @Extension(ordinal=-1.0)
    public static class DescriptorImpl
    extends Descriptor<DockerComputerConnector> {
        public String getDisplayName() {
            return "(Experimental) Attach Docker container";
        }
    }
}

