/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.connector;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.thoughtworks.xstream.InitializationException;
import hudson.model.AbstractDescribableImpl;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.Which;
import hudson.slaves.ComputerLauncher;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DockerComputerConnector
extends AbstractDescribableImpl<DockerComputerConnector> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerComputerConnector.class);
    protected static final File remoting;

    public void beforeContainerCreated(DockerCloud cloud, DockerTemplate template, CreateContainerCmd cmd) throws IOException, InterruptedException {
    }

    public void beforeContainerStarted(DockerCloud cloud, DockerTemplate template, String containerId) throws IOException, InterruptedException {
    }

    public void afterContainerStarted(DockerCloud cloud, DockerTemplate template, String containerId) throws IOException, InterruptedException {
    }

    public void afterAgentCreated(DockerCloud cloud, DockerTemplate template, String containerId, DockerSlave slave) throws IOException, InterruptedException {
    }

    protected void ensureWaiting(CreateContainerCmd cmd) {
        if (cmd.getCmd() == null || cmd.getCmd().length == 0) {
            cmd.withCmd(new String[]{"/bin/sh"}).withTty(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(false));
        }
    }

    protected String injectRemotingJar(String containerId, String workdir, DockerClient client) throws IOException {
        client.copyArchiveToContainerCmd(containerId).withHostResource(remoting.getAbsolutePath()).withRemotePath(workdir).exec();
        return workdir + '/' + remoting.getName();
    }

    public final ComputerLauncher launch(DockerCloud cloud, @Nonnull String containerId, DockerTemplate template, TaskListener listener) throws IOException, InterruptedException {
        InspectContainerResponse inspect = cloud.getClient().inspectContainerCmd(containerId).exec();
        Boolean running = inspect.getState().getRunning();
        if (Boolean.FALSE.equals(running)) {
            listener.error("Container {} is not running. {}", new Object[]{containerId, inspect.getState().getStatus()});
            throw new IOException("Container is not running.");
        }
        return this.launch(cloud, template, inspect, listener);
    }

    protected abstract ComputerLauncher launch(DockerCloud var1, DockerTemplate var2, InspectContainerResponse var3, TaskListener var4) throws IOException, InterruptedException;

    static {
        try {
            remoting = Which.jarFile(Channel.class);
        }
        catch (IOException e) {
            throw new InitializationException("Failed to resolve path to remoting.jar");
        }
    }
}

