/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.connector;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerComputer;
import com.nirima.jenkins.plugins.docker.DockerSlave;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.SlaveComputer;
import io.jenkins.docker.connector.DockerComputerConnector;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DockerComputerJNLPConnector
extends DockerComputerConnector {
    private String user;
    private final JNLPLauncher jnlpLauncher;

    @DataBoundConstructor
    public DockerComputerJNLPConnector(JNLPLauncher jnlpLauncher) {
        this.jnlpLauncher = jnlpLauncher;
    }

    public String getUser() {
        return this.user;
    }

    @DataBoundSetter
    public void setUser(String user) {
        this.user = user;
    }

    public JNLPLauncher getJnlpLauncher() {
        return this.jnlpLauncher;
    }

    @Override
    protected ComputerLauncher launch(DockerCloud cloud, DockerTemplate template, InspectContainerResponse inspect, TaskListener listener) throws IOException, InterruptedException {
        return new JNLPLauncher();
    }

    @Override
    public void beforeContainerCreated(DockerCloud cloud, DockerTemplate template, CreateContainerCmd cmd) throws IOException, InterruptedException {
        this.ensureWaiting(cmd);
    }

    @Override
    public void afterContainerStarted(DockerCloud cloud, DockerTemplate template, String containerId) throws IOException, InterruptedException {
        DockerClient client = cloud.getClient();
        this.injectRemotingJar(containerId, template.remoteFs, client);
    }

    @Override
    public void afterAgentCreated(DockerCloud cloud, DockerTemplate template, String containerId, DockerSlave slave) throws InterruptedException {
        DockerComputer computer = slave.getComputer();
        if (computer == null) {
            throw new IllegalStateException("DockerSlave hasn't been registered as an active Node");
        }
        DockerClient client = cloud.getClient();
        List<String> args = this.buildCommand(template, (SlaveComputer)computer);
        ExecCreateCmd cmd = client.execCreateCmd(containerId).withAttachStdout(Boolean.valueOf(true)).withTty(Boolean.valueOf(true)).withCmd(args.toArray(new String[args.size()]));
        if (StringUtils.isNotBlank((String)this.user)) {
            cmd.withUser(this.user);
        }
        ExecCreateCmdResponse exec = (ExecCreateCmdResponse)cmd.exec();
        PrintStream logger = computer.getListener().getLogger();
        ExecStartResultCallback start = (ExecStartResultCallback)client.execStartCmd(exec.getId()).withDetach(Boolean.valueOf(true)).withTty(Boolean.valueOf(true)).exec((ResultCallback)new ExecStartResultCallback((OutputStream)logger, (OutputStream)logger));
        start.awaitCompletion();
    }

    private List<String> buildCommand(DockerTemplate template, SlaveComputer computer) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("java");
        String vmargs = this.jnlpLauncher.vmargs;
        if (StringUtils.isNotBlank((String)vmargs)) {
            args.addAll(Arrays.asList(vmargs.split(" ")));
        }
        args.addAll(Arrays.asList("-cp", template.remoteFs + "/" + remoting.getName(), "hudson.remoting.jnlp.Main", "-headless"));
        if (StringUtils.isNotBlank((String)this.jnlpLauncher.tunnel)) {
            args.addAll(Arrays.asList("--tunnel", this.jnlpLauncher.tunnel));
        }
        args.addAll(Arrays.asList("-url", Jenkins.getInstance().getRootUrl(), computer.getJnlpMac(), computer.getName()));
        return args;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<DockerComputerConnector> {
        public String getDisplayName() {
            return "Connect with JNLP";
        }
    }
}

