/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.connector;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.NetworkSettings;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.DockerTemplateBase;
import com.nirima.jenkins.plugins.docker.utils.PortUtils;
import com.trilead.ssh2.signature.RSAPublicKey;
import com.trilead.ssh2.signature.RSASHA1Verify;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.remoting.Base64;
import hudson.slaves.ComputerLauncher;
import hudson.util.ListBoxModel;
import io.jenkins.docker.connector.DockerComputerConnector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Key;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import jenkins.bouncycastle.api.PEMEncodable;
import jenkins.model.Jenkins;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerComputerSSHConnector
extends DockerComputerConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerComputerSSHConnector.class);
    private final SSHKeyStrategy sshKeyStrategy;
    private int port;
    private String jvmOptions;
    private String javaPath;
    private String prefixStartSlaveCmd;
    private String suffixStartSlaveCmd;
    private Integer launchTimeoutSeconds;

    @DataBoundConstructor
    public DockerComputerSSHConnector(SSHKeyStrategy sshKeyStrategy) {
        this.sshKeyStrategy = sshKeyStrategy;
    }

    public SSHKeyStrategy getSshKeyStrategy() {
        return this.sshKeyStrategy;
    }

    public int getPort() {
        return this.port;
    }

    @DataBoundSetter
    public void setPort(int port) {
        this.port = port;
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    @DataBoundSetter
    public void setJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    public String getJavaPath() {
        return this.javaPath;
    }

    @DataBoundSetter
    public void setJavaPath(String javaPath) {
        this.javaPath = javaPath;
    }

    public String getPrefixStartSlaveCmd() {
        return this.prefixStartSlaveCmd;
    }

    @DataBoundSetter
    public void setPrefixStartSlaveCmd(String prefixStartSlaveCmd) {
        this.prefixStartSlaveCmd = prefixStartSlaveCmd;
    }

    public String getSuffixStartSlaveCmd() {
        return this.suffixStartSlaveCmd;
    }

    @DataBoundSetter
    public void setSuffixStartSlaveCmd(String suffixStartSlaveCmd) {
        this.suffixStartSlaveCmd = suffixStartSlaveCmd;
    }

    public Integer getLaunchTimeoutSeconds() {
        return this.launchTimeoutSeconds;
    }

    @DataBoundSetter
    public void setLaunchTimeoutSeconds(Integer launchTimeoutSeconds) {
        this.launchTimeoutSeconds = launchTimeoutSeconds;
    }

    @Override
    public void beforeContainerCreated(DockerCloud cloud, DockerTemplate template, CreateContainerCmd cmd) throws IOException, InterruptedException {
        if (cmd.getCmd() == null || cmd.getCmd().length == 0) {
            if (this.sshKeyStrategy.getInjectedKey() != null) {
                cmd.withCmd(new String[]{"/usr/sbin/sshd", "-D", "-p", String.valueOf(this.port), "-o", "AuthorizedKeysCommand /root/authorized_key", "-o", "AuthorizedKeysCommandUser root"});
            } else {
                cmd.withCmd(new String[]{"/usr/sbin/sshd", "-D", "-p", String.valueOf(this.port)});
            }
        }
        cmd.withPortSpecs(new String[]{this.port + "/tcp"});
        cmd.withPortBindings(new PortBinding[]{PortBinding.parse((String)(":" + this.port))});
        cmd.withExposedPorts(new ExposedPort[]{ExposedPort.parse((String)(this.port + "/tcp"))});
    }

    @Override
    public void beforeContainerStarted(DockerCloud cloud, DockerTemplate template, String containerId) throws IOException, InterruptedException {
        String key = this.sshKeyStrategy.getInjectedKey();
        if (key != null) {
            String AuthorizedKeysCommand = "#!/bin/sh\n[ \"$1\" = \"" + this.sshKeyStrategy.getUser() + "\" ] && echo '" + key + "'|| :";
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                 TarArchiveOutputStream tar = new TarArchiveOutputStream((OutputStream)bos);){
                TarArchiveEntry entry = new TarArchiveEntry("authorized_key");
                entry.setSize((long)AuthorizedKeysCommand.getBytes().length);
                entry.setMode(448);
                tar.putArchiveEntry((ArchiveEntry)entry);
                tar.write(AuthorizedKeysCommand.getBytes());
                tar.closeArchiveEntry();
                tar.close();
                try (ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());){
                    cloud.getClient().copyArchiveToContainerCmd(containerId).withTarInputStream((InputStream)is).withRemotePath("/root").exec();
                }
            }
        }
    }

    @Override
    protected ComputerLauncher launch(DockerCloud cloud, DockerTemplate template, InspectContainerResponse inspect, TaskListener listener) throws IOException, InterruptedException {
        if ("exited".equals(inspect.getState().getStatus())) {
            LOGGER.error("Failed to launch docker SSH agent :" + inspect.getState().getExitCode());
            throw new IOException("Failed to launch docker SSH agent. Container exited with status " + inspect.getState().getExitCode());
        }
        LOGGER.debug("container created {}", (Object)inspect);
        InetSocketAddress address = this.getBindingForPort(cloud, inspect, this.port);
        PortUtils.ConnectionCheck connectionCheck = PortUtils.connectionCheck(address).withRetries(30).withEveryRetryWaitFor(2, TimeUnit.SECONDS);
        if (!connectionCheck.execute() || !connectionCheck.useSSH().execute()) {
            throw new IOException("SSH service didn't started after 60s.");
        }
        return this.sshKeyStrategy.getSSHLauncher(address, this);
    }

    private InetSocketAddress getBindingForPort(DockerCloud cloud, InspectContainerResponse ir, int internalPort) {
        Ports.Binding[] sshBindings;
        ExposedPort sshPort = new ExposedPort(internalPort);
        String host = null;
        Integer port = 22;
        NetworkSettings networkSettings = ir.getNetworkSettings();
        Ports ports = networkSettings.getPorts();
        Map bindings = ports.getBindings();
        for (Ports.Binding b : sshBindings = (Ports.Binding[])bindings.get(sshPort)) {
            String hps = b.getHostPortSpec();
            port = Integer.valueOf(hps);
            host = b.getHostIp();
        }
        if (host == null || host.equals("0.0.0.0")) {
            String url = cloud.getDockerHost().getUri();
            host = this.getDockerHostFromCloud(cloud);
            if (url.startsWith("unix") && (host == null || host.trim().isEmpty())) {
                host = "0.0.0.0";
            } else if (host == null || host.equals("0.0.0.0")) {
                host = networkSettings.getIpAddress();
                port = internalPort;
            }
        }
        return new InetSocketAddress(host, (int)port);
    }

    private String getDockerHostFromCloud(DockerCloud cloud) {
        String url = cloud.getDockerHost().getUri();
        String dockerHostname = cloud.getDockerHostname();
        if (dockerHostname != null && !dockerHostname.trim().isEmpty()) {
            return dockerHostname;
        }
        URI uri = URI.create(url);
        if (uri.getScheme().equals("unix")) {
            return null;
        }
        return uri.getHost();
    }

    private static class DockerSSHLauncher
    extends SSHLauncher {
        private String user;
        private String privateKey;

        public DockerSSHLauncher(String host, int port, String user, String privateKey, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds) {
            super(host, port, "InstanceIdentity", jvmOptions, javaPath, prefixStartSlaveCmd, suffixStartSlaveCmd, launchTimeoutSeconds);
            this.user = user;
            this.privateKey = privateKey;
        }

        public StandardUsernameCredentials getCredentials() {
            return new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, "InstanceIdentity", this.user, (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(this.privateKey), null, "private key for docker ssh agent");
        }
    }

    public static class ManuallyConfiguredSSHKey
    extends SSHKeyStrategy {
        private final String credentialsId;

        @DataBoundConstructor
        public ManuallyConfiguredSSHKey(String credentialsId) {
            this.credentialsId = credentialsId;
        }

        public String getCredentialsId() {
            return this.credentialsId;
        }

        @Override
        public String getUser() {
            return SSHLauncher.lookupSystemCredentials((String)this.credentialsId).getUsername();
        }

        @Override
        public ComputerLauncher getSSHLauncher(InetSocketAddress address, DockerComputerSSHConnector connector) throws IOException {
            return new SSHLauncher(address.getHostString(), address.getPort(), this.getCredentialsId(), connector.jvmOptions, connector.javaPath, connector.prefixStartSlaveCmd, connector.suffixStartSlaveCmd, connector.launchTimeoutSeconds);
        }

        @Override
        public String getInjectedKey() throws IOException {
            return null;
        }

        @Extension
        public static final class DescriptorImpl
        extends Descriptor<SSHKeyStrategy> {
            @Nonnull
            public String getDisplayName() {
                return "Use configured SSH credentials";
            }

            public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
                return DockerTemplateBase.DescriptorImpl.doFillCredentialsIdItems(context);
            }
        }
    }

    public static class InjectSSHKey
    extends SSHKeyStrategy {
        private final String user;

        @DataBoundConstructor
        public InjectSSHKey(String user) {
            this.user = user;
        }

        @Override
        public String getUser() {
            return this.user;
        }

        @Override
        public ComputerLauncher getSSHLauncher(InetSocketAddress address, DockerComputerSSHConnector connector) throws IOException {
            InstanceIdentity id = InstanceIdentity.get();
            String pem = PEMEncodable.create((Key)id.getPrivate()).encode();
            return new DockerSSHLauncher(address.getHostString(), address.getPort(), this.user, pem, connector.jvmOptions, connector.javaPath, connector.prefixStartSlaveCmd, connector.suffixStartSlaveCmd, connector.launchTimeoutSeconds);
        }

        @Override
        public String getInjectedKey() throws IOException {
            InstanceIdentity id = InstanceIdentity.get();
            java.security.interfaces.RSAPublicKey rsa = id.getPublic();
            return "ssh-rsa " + Base64.encode((byte[])RSASHA1Verify.encodeSSHRSAPublicKey((RSAPublicKey)new RSAPublicKey(rsa.getPublicExponent(), rsa.getModulus())));
        }

        @Extension
        public static final class DescriptorImpl
        extends Descriptor<SSHKeyStrategy> {
            @Nonnull
            public String getDisplayName() {
                return "Inject SSH key";
            }
        }
    }

    public static abstract class SSHKeyStrategy
    extends AbstractDescribableImpl<SSHKeyStrategy> {
        public abstract String getInjectedKey() throws IOException;

        public abstract String getUser();

        public abstract ComputerLauncher getSSHLauncher(InetSocketAddress var1, DockerComputerSSHConnector var2) throws IOException;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<DockerComputerConnector> {
        public String getDisplayName() {
            return "Connect with SSH";
        }

        public List getSSHKeyStrategyDescriptors() {
            return Jenkins.getInstance().getDescriptorList(SSHKeyStrategy.class);
        }
    }
}

