/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.docker.api;

import com.nirima.docker.client.model.Image;
import com.nirima.docker.client.model.ImageInspectResponse;
import com.nirima.docker.client.model.SearchItem;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/images")
public interface ImagesClient {
    @GET
    @Path(value="/json")
    public List<Image> listImages(@DefaultValue(value="") @QueryParam(value="filter") String var1, @QueryParam(value="all") boolean var2);

    @POST
    @Path(value="/create")
    public InputStream createImage(@QueryParam(value="fromImage") String var1, @QueryParam(value="fromSrc") String var2, @QueryParam(value="repo") String var3, @QueryParam(value="tag") String var4, @QueryParam(value="registry") String var5);

    @POST
    @Path(value="/create")
    public InputStream createImage(@QueryParam(value="image") String var1, @QueryParam(value="fromSrc") String var2, @QueryParam(value="repo") String var3, @QueryParam(value="tag") String var4);

    @POST
    @Path(value="/{name}/insert")
    public void insertFile(@PathParam(value="name") String var1);

    @GET
    @Path(value="/{name}/json")
    public ImageInspectResponse inspectImage(@PathParam(value="name") String var1);

    @GET
    @Path(value="/{name}/history")
    public List<Image> getImageHistory(@PathParam(value="name") String var1);

    @POST
    @Path(value="/{name}/push")
    @Consumes(value={"text/plain"})
    public InputStream pushImageOnRegistry(@PathParam(value="name") String var1, @QueryParam(value="registry") String var2);

    @POST
    @Path(value="/{name}/tag")
    public void tagImage(@PathParam(value="name") String var1, @QueryParam(value="repo") String var2, @QueryParam(value="force") boolean var3);

    @DELETE
    @Path(value="{name}")
    @Produces(value={"text/plain"})
    public List<Map<String, String>> removeImage(@PathParam(value="name") String var1, @QueryParam(value="force") boolean var2, @QueryParam(value="noprune") boolean var3);

    @GET
    @Path(value="/search")
    public List<SearchItem> searchForImage(@QueryParam(value="term") String var1);

    @POST
    @Path(value="/build")
    @Consumes(value={"application/tar"})
    public InputStream buildImageFromStream(InputStream var1, @QueryParam(value="t") String var2, @QueryParam(value="q") boolean var3, @QueryParam(value="nocache") boolean var4);
}

