/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.docker.api;

import com.nirima.docker.client.model.SearchResult;
import java.io.InputStream;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

@Path(value="/v1")
public interface RegistryClient {
    @GET
    @Path(value="/images/{imageId}/layer")
    public InputStream getImageLayer(@PathParam(value="imageId") String var1);

    @PUT
    @Path(value="/images/{imageId}/layer")
    public void getImageLayer(@PathParam(value="imageId") String var1, InputStream var2);

    @PUT
    @Path(value="/images/{imageId}/json")
    public void putImage(@PathParam(value="imageId") String var1);

    @GET
    @Path(value="/images/{imageId}/ancestry")
    public InputStream getImageAncestry(@PathParam(value="imageId") String var1);

    @GET
    @Path(value="/repositories/{namespace}/{repository}/tags")
    public Map<String, String> getRepositoryTags(@PathParam(value="namespace") String var1, @PathParam(value="repository") String var2);

    @GET
    @Path(value="/repositories/{namespace}/{repository}/tags/{tag}")
    public String getRepositoryTag(@PathParam(value="namespace") String var1, @PathParam(value="repository") String var2, @PathParam(value="tag") String var3);

    @DELETE
    @Path(value="/repositories/{namespace}/{repository}/tags/{tag}")
    public String deleteRepositoryTag(@PathParam(value="namespace") String var1, @PathParam(value="repository") String var2, @PathParam(value="tag") String var3);

    @PUT
    @Path(value="/repositories/{namespace}/{repository}/tags/{tag}")
    public String putRepositoryTag(@PathParam(value="namespace") String var1, @PathParam(value="repository") String var2, @PathParam(value="tag") String var3);

    @DELETE
    @Path(value="/repositories/{namespace}/{repository}")
    public String deleteRepository(@PathParam(value="namespace") String var1, @PathParam(value="repository") String var2);

    @GET
    @Path(value="/_ping")
    public void ping();

    @GET
    @Path(value="/search")
    public SearchResult search(@QueryParam(value="q") String var1);
}

