/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.docker.client;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.nirima.docker.api.ContainersClient;
import com.nirima.docker.api.ImagesClient;
import com.nirima.docker.api.MiscClient;
import com.nirima.docker.client.DockerClientBase;
import com.nirima.docker.client.DockerException;
import com.nirima.docker.client.command.BuildCommandBuilder;
import com.nirima.docker.client.command.PushCommandBuilder;
import com.nirima.docker.client.model.ContainerConfig;
import com.nirima.docker.client.model.ContainerCreateResponse;
import com.nirima.docker.client.model.ContainerInspectResponse;
import com.nirima.docker.client.model.EventStreamItem;
import com.nirima.docker.client.model.FileChanges;
import com.nirima.docker.client.model.HostConfig;
import com.nirima.docker.client.model.ImageAction;
import com.nirima.docker.client.model.ImageInspectResponse;
import com.nirima.docker.client.model.Info;
import com.nirima.docker.client.model.SearchItem;
import com.nirima.docker.client.model.Version;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.proxy.WebResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerClient
extends DockerClientBase
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(DockerClient.class);

    public static Builder builder() {
        return new Builder();
    }

    public DockerClient(String serverUrl, ClientConfig clientConfig) {
        super(serverUrl, clientConfig);
    }

    public ImagesClient imagesApi() {
        return (ImagesClient)WebResourceFactory.newResource(ImagesClient.class, (WebTarget)this.webTarget, (boolean)false, this.getHeaders(), Collections.emptyList(), (Form)new Form());
    }

    public ContainersClient containersApi() {
        return (ContainersClient)WebResourceFactory.newResource(ContainersClient.class, (WebTarget)this.webTarget);
    }

    public MiscClient miscApi() {
        return (MiscClient)WebResourceFactory.newResource(MiscClient.class, (WebTarget)this.webTarget);
    }

    public System system() {
        return new System();
    }

    public PullCommandBuilder createPullCommand() {
        return new PullCommandBuilder();
    }

    public BuildCommandBuilder createBuildCommand() {
        return new BuildCommandBuilder(this);
    }

    public PushCommandBuilder createPushCommand() {
        return new PushCommandBuilder(this);
    }

    public Containers containers() {
        return new Containers();
    }

    public Container container(String containerId) {
        Preconditions.checkNotNull((Object)containerId);
        return new Container(containerId);
    }

    public Images images() {
        return new Images();
    }

    public Image image(String imageId) {
        Preconditions.checkNotNull((Object)imageId);
        return new Image(imageId);
    }

    public class Image {
        private final String imageId;

        private Image(String imageId) {
            this.imageId = imageId;
        }

        public void remove() {
            try {
                DockerClient.this.imagesApi().removeImage(this.imageId, false, false);
            }
            catch (NotFoundException ex) {
                log.warn("Remove Image {} not found", (Object)this.imageId);
            }
        }

        public RemoveCommand removeCommand() {
            return new RemoveCommand();
        }

        public ImageInspectResponse inspect() {
            return DockerClient.this.imagesApi().inspectImage(this.imageId);
        }

        public void tag(String name, boolean force) {
            DockerClient.this.imagesApi().tagImage(this.imageId, name, force);
        }

        public void push(String registry) {
            DockerClient.this.imagesApi().pushImageOnRegistry(this.imageId, registry);
        }

        public class RemoveCommand {
            boolean force = false;
            boolean noprune = false;

            public RemoveCommand force(boolean force) {
                this.force = force;
                return this;
            }

            public RemoveCommand noPrune(boolean noprune) {
                this.noprune = noprune;
                return this;
            }

            public Collection<ImageAction> execute() {
                try {
                    List<Map<String, String>> items = DockerClient.this.imagesApi().removeImage(Image.this.imageId, this.force, this.noprune);
                    return Collections2.transform(items, (Function)new Function<Map<String, String>, ImageAction>(){

                        public ImageAction apply(@Nullable Map<String, String> input) {
                            Map.Entry entry = (Map.Entry)Iterators.get(input.entrySet().iterator(), (int)0);
                            return new ImageAction(ImageAction.ActionType.valueOf((String)entry.getKey()), (String)entry.getValue());
                        }
                    });
                }
                catch (NotFoundException ex) {
                    log.warn("Remove Image {} not found", (Object)Image.this.imageId);
                    return Collections.emptySet();
                }
            }
        }
    }

    public class Images {
        public List<SearchItem> search(String term) {
            return DockerClient.this.imagesApi().searchForImage(term);
        }

        public void remove(Collection<String> images) throws DockerException {
            Preconditions.checkNotNull(images, (Object)"List of images can't be null");
            for (String imageName : images) {
                DockerClient.this.imagesApi().removeImage(imageName, false, false);
            }
        }

        public ImageFinder finder() {
            return new ImageFinder();
        }
    }

    public class ImageFinder {
        private String filter;
        private boolean allImages = false;

        public ImageFinder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public ImageFinder allImages(boolean allImages) {
            this.allImages = allImages;
            return this;
        }

        public List<com.nirima.docker.client.model.Image> list() {
            return DockerClient.this.imagesApi().listImages(this.filter, this.allImages);
        }
    }

    public class Containers {
        private Containers() {
        }

        public ContainerFinder finder() {
            return new ContainerFinder();
        }

        public ContainerCreateResponse create(ContainerConfig containerConfig) {
            return DockerClient.this.containersApi().createContainer(null, containerConfig);
        }
    }

    public class ContainerFinder {
        private boolean allContainers;
        private boolean latest = false;
        private int limit = -1;
        private boolean showSize;
        private String since;
        private String before;

        public ContainerFinder allContainers(boolean allContainers) {
            this.allContainers = allContainers;
            return this;
        }

        public ContainerFinder latest(boolean latest) {
            this.latest = latest;
            return this;
        }

        public ContainerFinder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public ContainerFinder showSize(boolean showSize) {
            this.showSize = showSize;
            return this;
        }

        public ContainerFinder since(String since) {
            this.since = since;
            return this;
        }

        public ContainerFinder before(String before) {
            this.before = before;
            return this;
        }

        public List<com.nirima.docker.client.model.Container> list() {
            return DockerClient.this.containersApi().listContainers(this.allContainers, this.limit, this.since, this.before, this.showSize);
        }
    }

    public class Container {
        private final String containerId;

        private Container(String containerId) {
            this.containerId = containerId;
        }

        public void start() {
            DockerClient.this.containersApi().startContainer(this.containerId, null);
        }

        public void start(HostConfig hostConfig) {
            DockerClient.this.containersApi().startContainer(this.containerId, hostConfig);
        }

        public void stop() {
            DockerClient.this.containersApi().stopContainer(this.containerId, null);
        }

        public void stop(long secondsToWait) {
            DockerClient.this.containersApi().stopContainer(this.containerId, secondsToWait);
        }

        public void remove() {
            try {
                DockerClient.this.containersApi().removeContainer(this.containerId);
            }
            catch (NotFoundException ex) {
                log.warn("Remove container {} not found", (Object)this.containerId);
            }
        }

        public void remove(boolean includingVolumes) {
            DockerClient.this.containersApi().removeContainer(this.containerId, includingVolumes, false);
        }

        public int waitForContainer() {
            return DockerClient.this.containersApi().waitForContainer((String)this.containerId).StatusCode;
        }

        public List<FileChanges> getFilesystemChanges() {
            return DockerClient.this.containersApi().getFilesystemChanges(this.containerId);
        }

        public void kill() {
            DockerClient.this.containersApi().killContainer(this.containerId);
        }

        public void restart() {
            DockerClient.this.containersApi().restartContainer(this.containerId, null);
        }

        public void restart(long secondsToWait) {
            DockerClient.this.containersApi().restartContainer(this.containerId, secondsToWait);
        }

        public ContainerInspectResponse inspect() {
            return DockerClient.this.containersApi().inspectContainer(this.containerId);
        }

        public CommitCommandBuilder createCommitCommand() {
            return new CommitCommandBuilder();
        }

        public InputStream log() throws IOException {
            InputStream inputStream = DockerClient.this.containersApi().attachToContainer(this.containerId, true, false, false, true, true);
            inputStream.read(new byte[8]);
            return inputStream;
        }

        public final class CommitCommandBuilder {
            private String repo;
            private String tag;
            private String message;
            private String author;
            private String run;

            private CommitCommandBuilder() {
            }

            public CommitCommandBuilder repo(String repo) {
                this.repo = repo;
                return this;
            }

            public CommitCommandBuilder tag(String tag) {
                this.tag = tag;
                return this;
            }

            public CommitCommandBuilder message(String message) {
                this.message = message;
                return this;
            }

            public CommitCommandBuilder author(String author) {
                this.author = author;
                return this;
            }

            public CommitCommandBuilder run(String run) {
                this.run = run;
                return this;
            }

            public String execute() {
                return DockerClient.this.miscApi().commit(Container.this.containerId, this.message, this.repo, this.tag, this.author, this.run).getId();
            }
        }
    }

    public class PullCommandBuilder {
        private String fromImage;
        private String fromSrc;
        private String repo;
        private String tag;
        private String registry;

        private PullCommandBuilder() {
        }

        public PullCommandBuilder image(String image) {
            this.fromImage = image;
            return this;
        }

        public PullCommandBuilder fromSrc(String src) {
            this.fromSrc = src;
            return this;
        }

        public PullCommandBuilder repository(String repo) {
            this.repo = repo;
            return this;
        }

        public PullCommandBuilder withTag(String tag) {
            this.tag = tag;
            return this;
        }

        public PullCommandBuilder fromRegistry(String registry) {
            this.registry = registry;
            return this;
        }

        public InputStream execute() {
            return DockerClient.this.imagesApi().createImage(this.fromImage, this.fromSrc, this.repo, this.tag, this.registry);
        }
    }

    public class System {
        private System() {
        }

        public Info info() {
            return DockerClient.this.miscApi().info();
        }

        public Version version() {
            return DockerClient.this.miscApi().version();
        }

        public Collection<EventStreamItem> build(File dockerFolder, String tag) throws DockerException, IOException {
            Preconditions.checkNotNull((Object)dockerFolder, (Object)"Folder is null");
            Preconditions.checkArgument((boolean)dockerFolder.exists(), (String)"Folder %s doesn't exist", (Object[])new Object[]{dockerFolder});
            Preconditions.checkState((boolean)new File(dockerFolder, "Dockerfile").exists(), (Object)("Dockerfile doesn't exist in " + dockerFolder));
            return DockerClient.this.createBuildCommand().dockerFile(new File(dockerFolder, "Dockerfile")).tag(tag).execute().getItems();
        }
    }

    public static class Builder
    extends DockerClientBase.Builder<Builder> {
        public Builder fromClient(DockerClient client) {
            this.serverUrl = client.serverUrl;
            this.connectTimeout = (Integer)client.webTarget.getConfiguration().getProperty("jersey.config.client.connectTimeout");
            this.readTimeout = (Integer)client.webTarget.getConfiguration().getProperty("jersey.config.client.connectTimeout");
            return this;
        }

        public DockerClient build() {
            Preconditions.checkNotNull((Object)this.serverUrl);
            return new DockerClient(this.serverUrl, this.getClientConfig());
        }
    }
}

