/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.docker.client;

import com.google.common.base.Preconditions;
import com.nirima.docker.jersey.NullReader;
import com.nirima.jersey.filter.Slf4jLoggingFilter;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.filter.LoggingFilter;

public abstract class DockerClientBase {
    protected MultivaluedMap<String, Object> headers;
    protected final String serverUrl;
    protected final WebTarget webTarget;

    protected DockerClientBase(String serverUrl, ClientConfig cc) {
        this.serverUrl = serverUrl;
        this.webTarget = ClientBuilder.newClient((Configuration)cc).target(serverUrl);
    }

    public MultivaluedMap<String, Object> getHeaders() {
        if (this.headers == null) {
            this.headers = new MultivaluedHashMap();
            this.headers.putSingle((Object)"X-Registry-Auth", (Object)"docker");
        }
        return this.headers;
    }

    public static class Builder<T extends Builder>
    implements Serializable {
        protected String serverUrl;
        protected Logging logging = Logging.NONE;
        protected int connectTimeout = 10000;
        protected int readTimeout = -1;

        public T withUrl(String url) {
            Preconditions.checkNotNull((Object)url);
            this.serverUrl = url;
            return (T)this;
        }

        public T connectTimeout(int ms) {
            this.connectTimeout = ms;
            return (T)this;
        }

        public T readTimeout(int ms) {
            this.readTimeout = ms;
            return (T)this;
        }

        public T withLogging(Logging logging) {
            Preconditions.checkNotNull((Object)((Object)logging));
            this.logging = logging;
            return (T)this;
        }

        protected ClientConfig getClientConfig() {
            ClientConfig cc = new ClientConfig();
            cc.property("jersey.config.client.connectTimeout", (Object)this.connectTimeout);
            if (this.readTimeout != -1) {
                cc.property("jersey.config.client.readTimeout", (Object)this.readTimeout);
            }
            cc.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.CHUNKED);
            cc.property("jersey.config.client.chunkedEncodingSize", (Object)0x100000);
            cc.register(NullReader.class);
            if (this.logging == Logging.JUL) {
                LoggingFilter lf = new LoggingFilter(Logger.getLogger(LoggingFilter.class.getName()), true);
                cc.register((Object)lf);
            } else if (this.logging == Logging.SLF4J) {
                cc.register((Object)Slf4jLoggingFilter.builder().build());
            }
            return cc;
        }
    }

    public static enum Logging {
        NONE,
        SLF4J,
        JUL;

    }
}

