/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.docker.client;

import com.google.common.base.Preconditions;
import com.nirima.docker.api.RegistryClient;
import com.nirima.docker.client.DockerClientBase;
import java.io.Serializable;
import java.net.URL;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.proxy.WebResourceFactory;

public class DockerRegistryClient
extends DockerClientBase
implements Serializable {
    public static Builder builder() {
        return new Builder();
    }

    private DockerRegistryClient(String serverUrl, ClientConfig cc) {
        super(serverUrl, cc);
    }

    public RegistryClient registryApi() {
        return (RegistryClient)WebResourceFactory.newResource(RegistryClient.class, (WebTarget)this.webTarget);
    }

    public static class Builder
    extends DockerClientBase.Builder<Builder> {
        public Builder fromClient(DockerRegistryClient client) {
            this.serverUrl = client.serverUrl;
            this.connectTimeout = (Integer)client.webTarget.getConfiguration().getProperty("jersey.config.client.connectTimeout");
            this.readTimeout = (Integer)client.webTarget.getConfiguration().getProperty("jersey.config.client.connectTimeout");
            return this;
        }

        public DockerRegistryClient build() {
            Preconditions.checkNotNull((Object)this.serverUrl);
            return new DockerRegistryClient(this.serverUrl, this.getClientConfig());
        }

        public Builder withUrl(URL url) {
            this.serverUrl = "http://" + url.getHost() + ":" + url.getPort();
            return this;
        }
    }
}

