/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.docker.client.command;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.collect.ImmutableList;
import com.kpelykh.docker.client.utils.CompressArchiveUtil;
import com.nirima.docker.client.DockerClient;
import com.nirima.docker.client.DockerException;
import com.nirima.docker.client.command.BuildCommandResponse;
import com.nirima.docker.client.model.EventStreamItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;

public class BuildCommandBuilder {
    private final DockerClient client;
    private File dockerFile;
    private File tarFile;
    private String tag;

    public BuildCommandBuilder(DockerClient client) {
        this.client = client;
    }

    public BuildCommandBuilder dockerFile(File path) {
        if (!path.exists()) {
            throw new DockerException("Dockerfile does not exist");
        }
        this.dockerFile = path;
        return this;
    }

    public BuildCommandBuilder useTarFile(File tarFile) {
        this.tarFile = tarFile;
        return this;
    }

    public BuildCommandBuilder tag(String tag) {
        this.tag = tag;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildCommandResponse execute() throws IOException {
        InputStream results;
        boolean delete = false;
        if (this.tarFile == null) {
            delete = true;
            this.tarFile = this.makeTarFile();
        }
        FileInputStream tarInputStream = new FileInputStream(this.tarFile);
        try {
            results = this.client.miscApi().build(this.tag, false, false, false, false, tarInputStream);
        }
        finally {
            tarInputStream.close();
            if (delete) {
                this.tarFile.delete();
                this.tarFile = null;
            }
        }
        Collection<EventStreamItem> items = this.makeEventStream(results);
        return new BuildCommandResponse(items);
    }

    private File makeTarFile() throws IOException {
        File dockerPath = this.dockerFile.getParentFile();
        String archiveNameWithOutExtension = UUID.randomUUID().toString();
        return CompressArchiveUtil.archiveTARFiles(dockerPath, archiveNameWithOutExtension);
    }

    private Collection<EventStreamItem> makeEventStream(InputStream inputStream) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectReader reader = mapper.reader(EventStreamItem.class);
        MappingIterator items = reader.readValues(inputStream);
        return ImmutableList.copyOf((Iterator)items);
    }
}

