/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.docker.client.command;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.nirima.docker.client.model.EventStreamItem;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class BuildCommandResponse
implements Serializable {
    private final Collection<EventStreamItem> items;

    public BuildCommandResponse(Collection<EventStreamItem> items) {
        this.items = items;
    }

    public Optional<String> imageId() {
        for (EventStreamItem item : this.items) {
            if (item.getStream() == null || !item.getStream().contains("Successfully built")) continue;
            String id = StringUtils.substringAfterLast((String)item.getStream(), (String)"Successfully built ").trim();
            return Optional.of((Object)id);
        }
        return Optional.absent();
    }

    public Collection<EventStreamItem> getItems() {
        return this.items;
    }

    public String toString() {
        return Joiner.on((String)"\n").join(this.items);
    }
}

