/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.docker.client.command;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.collect.ImmutableList;
import com.nirima.docker.client.DockerClient;
import com.nirima.docker.client.command.PushCommandResponse;
import com.nirima.docker.client.model.PushEventStreamItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;

public class PushCommandBuilder {
    private final DockerClient client;
    private String name;
    private String registry;
    private String tag;

    public PushCommandBuilder(DockerClient client) {
        this.client = client;
    }

    public PushCommandBuilder name(String name) {
        this.name = name;
        return this;
    }

    public PushCommandBuilder registry(String registry) {
        this.registry = registry;
        return this;
    }

    public PushCommandResponse execute() throws IOException {
        InputStream response = this.client.imagesApi().pushImageOnRegistry(this.name, this.registry);
        return new PushCommandResponse(this.makePushStream(response));
    }

    private Collection<PushEventStreamItem> makePushStream(InputStream inputStream) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectReader reader = mapper.reader(PushEventStreamItem.class);
        MappingIterator items = reader.readValues(inputStream);
        return ImmutableList.copyOf((Iterator)items);
    }
}

