/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.docker.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.base.Objects;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(using=Deserializer.class)
public class Ports
implements Serializable {
    private final Map<String, Port> ports = new HashMap<String, Port>();
    private Port[] mapping;

    private Ports() {
    }

    private void addPort(Port port) {
        this.ports.put(port.getPort(), port);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("ports", this.ports).add("mapping", (Object)this.mapping).toString();
    }

    public Map<String, Port> getAllPorts() {
        return this.ports;
    }

    public static class Serializer
    extends JsonSerializer<Ports> {
        public void serialize(Ports ports, JsonGenerator jsonGen, SerializerProvider serProvider) throws IOException, JsonProcessingException {
            jsonGen.writeStartObject();
            for (String portKey : ports.getAllPorts().keySet()) {
                Port p = ports.getAllPorts().get(portKey);
                jsonGen.writeFieldName(p.getPort() + "/" + p.getScheme());
                jsonGen.writeStartArray();
                jsonGen.writeStartObject();
                jsonGen.writeStringField("HostIp", p.hostIp);
                jsonGen.writeStringField("HostPort", p.hostPort);
                jsonGen.writeEndObject();
                jsonGen.writeEndArray();
            }
            jsonGen.writeEndObject();
        }
    }

    public static class Deserializer
    extends JsonDeserializer<Ports> {
        public Ports deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Ports out = new Ports();
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            Iterator it = node.fields();
            while (it.hasNext()) {
                Map.Entry field = (Map.Entry)it.next();
                if (((JsonNode)field.getValue()).equals((Object)NullNode.getInstance())) continue;
                String hostIp = ((JsonNode)field.getValue()).get(0).get("HostIp").textValue();
                String hostPort = ((JsonNode)field.getValue()).get(0).get("HostPort").textValue();
                out.addPort(Port.makePort((String)field.getKey(), hostIp, hostPort));
            }
            return out;
        }
    }

    public static class Port
    implements Serializable {
        private final String scheme;
        private final String port;
        private final String hostIp;
        private final String hostPort;

        public Port(String scheme_, String port_, String hostIp_, String hostPort_) {
            this.scheme = scheme_;
            this.port = port_;
            this.hostIp = hostIp_;
            this.hostPort = hostPort_;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getPort() {
            return this.port;
        }

        public String getHostIp() {
            return this.hostIp;
        }

        public String getHostPort() {
            return this.hostPort;
        }

        public static Port makePort(String full, String hostIp, String hostPort) {
            if (full == null) {
                return null;
            }
            String[] pieces = full.split("/");
            return new Port(pieces[1], pieces[0], hostIp, hostPort);
        }

        public String toString() {
            return "Port{scheme='" + this.scheme + '\'' + ", port='" + this.port + '\'' + ", hostIp='" + this.hostIp + '\'' + ", hostPort='" + this.hostPort + '\'' + '}';
        }
    }
}

