/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.docker.dockerfile;

import com.google.common.base.Objects;
import com.nirima.docker.client.DockerException;
import org.apache.commons.lang.StringUtils;

public class DockerfileStatement {
    protected final String statement;

    private DockerfileStatement(String statement) {
        this.statement = statement;
    }

    public static DockerfileStatement createFromLine(String cmd) {
        String[] addArgs = StringUtils.split((String)cmd, (String)" \t");
        if (addArgs.length > 0 && addArgs[0].equalsIgnoreCase("ADD")) {
            if (addArgs.length != 3) {
                throw new DockerException(String.format("Wrong format on line [%s]", cmd));
            }
            return new Add(cmd);
        }
        return new DockerfileStatement(cmd);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("statement", (Object)this.statement).toString();
    }

    public static class Add
    extends DockerfileStatement {
        private Add(String statement) {
            super(statement);
        }

        public String getSource() {
            return StringUtils.split((String)this.statement, (String)" \t")[1];
        }

        public String getDestination() {
            return StringUtils.split((String)this.statement, (String)" \t")[2];
        }

        @Override
        public String toString() {
            return Objects.toStringHelper((Object)this).add("statement", (Object)"ADD").add("source", (Object)this.getSource()).add("destination", (Object)this.getDestination()).toString();
        }
    }
}

