/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.common.file;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;

public class OSInfo<T extends Enum<T>> {
    private static String osName = System.getProperty("os.name");
    private static String version = System.getProperty("os.version");
    private static String arch = System.getProperty("os.arch");
    private final Map<T, String> typeMap = new LinkedHashMap<T, String>();

    public static OSInfo<OSType> getDefault() {
        return new OSInfo<OSType>(OSType.class);
    }

    public OSInfo(Class<T> enumClass) {
        this.putAll(enumClass);
    }

    public T getType() {
        LinkedList<Map.Entry<T, String>> entryList = new LinkedList<Map.Entry<T, String>>(this.typeMap.entrySet());
        ListIterator iterator = entryList.listIterator(entryList.size());
        while (iterator.hasPrevious()) {
            Map.Entry thisEntry = (Map.Entry)iterator.previous();
            if (!osName.matches((String)thisEntry.getValue())) continue;
            return (T)((Enum)thisEntry.getKey());
        }
        return null;
    }

    public <U extends Enum<U>> String put(U typeConst) {
        return this.typeMap.put(typeConst, ((OSProps)((Object)typeConst)).pattern());
    }

    public <U extends Enum<U>> String put(U typeConst, String pattern) {
        return this.typeMap.put(typeConst, pattern);
    }

    public <U extends Enum<U>> void putAll(Class<U> enumClass) {
        for (Enum typeConst : (Enum[])enumClass.getEnumConstants()) {
            this.put(typeConst);
        }
    }

    public static String osName() {
        return osName;
    }

    public static String version() {
        return version;
    }

    public static String arch() {
        return arch;
    }

    public static interface OSProps {
        public String pattern();
    }

    public static enum OSType implements OSProps
    {
        WINDOWS("(?i).*win.*"),
        MACINTOSH("(?i).*mac.*"),
        UNIX("(?i).*(?:nix|nux|aix).*"),
        SOLARIS("(?i).*sunos.*");

        private String pattern;

        private OSType(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public String pattern() {
            return this.pattern;
        }
    }
}

