/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.common.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class PathUtils {
    private static final String SUREFIRE_PATH = "surefire-reports";
    private static final String FAILSAFE_PATH = "failsafe-reports";

    private PathUtils() {
        throw new AssertionError((Object)"PathUtils is a static utility class that cannot be instantiated");
    }

    public static Path getNextPath(Path targetPath, String baseName, String extension) throws IOException {
        String newName;
        Objects.requireNonNull(targetPath, "[targetPath] must be non-null");
        Objects.requireNonNull(baseName, "[baseName] must be non-null");
        Objects.requireNonNull(extension, "[extension] must be non-null");
        File targetFile = targetPath.toFile();
        if (!targetFile.exists() || !targetFile.isDirectory()) {
            throw new IllegalArgumentException("[targetPath] must specify an existing directory");
        }
        if (baseName.isEmpty()) {
            throw new IllegalArgumentException("[baseName] must specify a non-empty string");
        }
        if (extension.isEmpty()) {
            throw new IllegalArgumentException("[extension] must specify a non-empty string");
        }
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("regex:" + baseName + "(-\\d+)?\\." + extension);
        try (Stream<Path> stream = Files.walk(targetPath, 1, new FileVisitOption[0]);){
            int base = baseName.length();
            int ext = extension.length() + 1;
            Optional<Integer> optional = stream.map(Path::getFileName).filter(pathMatcher::matches).map(String::valueOf).map(s -> "0" + s.substring(base, s.length() - ext)).map(s -> s.replace("0-", "")).map(Integer::valueOf).map(i -> i + 1).sorted(Comparator.reverseOrder()).findFirst();
            newName = optional.isPresent() ? baseName + "-" + optional.get() + "." + extension : baseName + "." + extension;
        }
        return targetPath.resolve(newName);
    }

    public static String getBaseDir() {
        Path currentRelativePath = Paths.get(System.getProperty("user.dir"), new String[0]);
        return currentRelativePath.toAbsolutePath().toString();
    }

    public static enum ReportsDirectory {
        SUREFIRE_1("(Test)(.*)", "surefire-reports"),
        SUREFIRE_2("(.*)(Test)", "surefire-reports"),
        SUREFIRE_3("(.*)(Tests)", "surefire-reports"),
        SUREFIRE_4("(.*)(TestCase)", "surefire-reports"),
        FAILSAFE_1("(IT)(.*)", "failsafe-reports"),
        FAILSAFE_2("(.*)(IT)", "failsafe-reports"),
        FAILSAFE_3("(.*)(ITCase)", "failsafe-reports"),
        ARTIFACT(".*", "artifact-capture");

        private String regex;
        private String folder;

        private ReportsDirectory(String regex, String folder) {
            this.regex = regex;
            this.folder = folder;
        }

        public String getRegEx() {
            return this.regex;
        }

        public String getFolder() {
            return this.folder;
        }

        public Path getPath() {
            return ReportsDirectory.getTargetPath().resolve(this.folder);
        }

        public static ReportsDirectory fromObject(Object obj) {
            String name = obj.getClass().getSimpleName();
            for (ReportsDirectory constant : ReportsDirectory.values()) {
                if (!name.matches(constant.regex)) continue;
                return constant;
            }
            throw new IllegalStateException("Someone removed the 'default' pattern from this enumeration");
        }

        public static Path getPathForObject(Object obj) {
            ReportsDirectory constant = ReportsDirectory.fromObject(obj);
            return ReportsDirectory.getTargetPath().resolve(constant.folder);
        }

        private static Path getTargetPath() {
            return Paths.get(PathUtils.getBaseDir(), "target");
        }
    }
}

