/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.JUnitConfig;
import com.nordstrom.automation.junit.JUnitRetryAnalyzer;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.NoRetry;
import com.nordstrom.automation.junit.RetriedTest;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryHandler {
    private static final ServiceLoader<JUnitRetryAnalyzer> retryAnalyzerLoader;
    private static final Logger LOGGER;

    private RetryHandler() {
        throw new AssertionError((Object)"RetryHandler is a static utility class that cannot be instantiated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runChildWithRetry(Object runner, FrameworkMethod method, RunNotifier notifier, int maxRetry) {
        boolean doRetry = false;
        Statement statement = (Statement)LifecycleHooks.invoke(runner, "methodBlock", method);
        Description description = (Description)LifecycleHooks.invoke(runner, "describeChild", method);
        AtomicInteger count = new AtomicInteger(maxRetry);
        do {
            EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
            eachNotifier.fireTestStarted();
            try {
                statement.evaluate();
                doRetry = false;
            }
            catch (AssumptionViolatedException thrown) {
                doRetry = RetryHandler.doRetry(method, thrown, count);
                if (doRetry) {
                    description = RetriedTest.proxyFor(description, thrown);
                    eachNotifier.fireTestIgnored();
                    continue;
                }
                eachNotifier.addFailedAssumption(thrown);
            }
            catch (Throwable thrown) {
                doRetry = RetryHandler.doRetry(method, thrown, count);
                if (doRetry) {
                    description = RetriedTest.proxyFor(description, thrown);
                    eachNotifier.fireTestIgnored();
                    continue;
                }
                eachNotifier.addFailure(thrown);
            }
            finally {
                eachNotifier.fireTestFinished();
            }
        } while (doRetry);
    }

    static boolean doRetry(FrameworkMethod method, Throwable thrown, AtomicInteger retryCounter) {
        boolean doRetry = false;
        if (retryCounter.decrementAndGet() > -1 && RetryHandler.isRetriable(method, thrown)) {
            LOGGER.warn("### RETRY ### {}", (Object)method);
            doRetry = true;
        }
        return doRetry;
    }

    static int getMaxRetry(Object runner, FrameworkMethod method) {
        int maxRetry = 0;
        NoRetry noRetryOnMethod = (NoRetry)method.getAnnotation(NoRetry.class);
        NoRetry noRetryOnClass = method.getDeclaringClass().getAnnotation(NoRetry.class);
        if (Boolean.FALSE.equals(LifecycleHooks.invoke(runner, "isIgnored", method)) && noRetryOnMethod == null && noRetryOnClass == null) {
            maxRetry = JUnitConfig.getConfig().getInteger(JUnitConfig.JUnitSettings.MAX_RETRY.key(), 0);
        }
        return maxRetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isRetriable(FrameworkMethod method, Throwable thrown) {
        ServiceLoader<JUnitRetryAnalyzer> serviceLoader = retryAnalyzerLoader;
        synchronized (serviceLoader) {
            for (JUnitRetryAnalyzer analyzer : retryAnalyzerLoader) {
                if (!analyzer.retry(method, thrown)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        LOGGER = LoggerFactory.getLogger(RetryHandler.class);
        retryAnalyzerLoader = ServiceLoader.load(JUnitRetryAnalyzer.class);
    }
}

