/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.google.common.base.Optional;
import com.nordstrom.automation.junit.JUnitWatcher;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.RunnerWatcher;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Run {
    private static final ThreadLocal<Deque<Object>> runnerStack;
    private static final Set<String> startNotified;
    private static final Set<String> finishNotified;
    private static final ServiceLoader<RunListener> runListenerLoader;
    private static final ServiceLoader<RunnerWatcher> runnerWatcherLoader;
    private static final Map<Object, Object> CHILD_TO_PARENT;
    private static final Set<RunNotifier> NOTIFIERS;
    private static final Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void intercept(@This Object runner, @SuperCall Callable<?> proxy, @Argument(value=0) RunNotifier notifier) throws Exception {
        Run.attachRunListeners(runner, notifier);
        try {
            Run.pushThreadRunner(runner);
            Run.fireRunStarted(runner);
            LifecycleHooks.callProxy(proxy);
        }
        finally {
            Run.fireRunFinished(runner);
            Run.popThreadRunner();
        }
    }

    static Object getParentOf(Object child) {
        return CHILD_TO_PARENT.get(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void attachRunListeners(Object runner, RunNotifier notifier) throws Exception {
        if (NOTIFIERS.add(notifier)) {
            Description description = (Description)LifecycleHooks.invoke(runner, "getDescription", new Object[0]);
            ServiceLoader<RunListener> serviceLoader = runListenerLoader;
            synchronized (serviceLoader) {
                for (RunListener listener : runListenerLoader) {
                    notifier.addListener(listener);
                    listener.testRunStarted(description);
                }
            }
        }
    }

    static void pushThreadRunner(Object runner) {
        runnerStack.get().push(runner);
    }

    static Object popThreadRunner() {
        return runnerStack.get().pop();
    }

    static Object getThreadRunner() {
        return runnerStack.get().peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean fireRunStarted(Object runner) {
        if (startNotified.add(runner.toString())) {
            List grandchildren = (List)LifecycleHooks.invoke(runner, "getChildren", new Object[0]);
            for (Object grandchild : grandchildren) {
                CHILD_TO_PARENT.put(grandchild, runner);
            }
            LOGGER.debug("runStarted: {}", runner);
            ServiceLoader<RunnerWatcher> serviceLoader = runnerWatcherLoader;
            synchronized (serviceLoader) {
                for (RunnerWatcher watcher : runnerWatcherLoader) {
                    watcher.runStarted(runner);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean fireRunFinished(Object runner) {
        if (finishNotified.add(runner.toString())) {
            LOGGER.debug("runFinished: {}", runner);
            ServiceLoader<RunnerWatcher> serviceLoader = runnerWatcherLoader;
            synchronized (serviceLoader) {
                for (RunnerWatcher watcher : runnerWatcherLoader) {
                    watcher.runFinished(runner);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends JUnitWatcher> Optional<T> getAttachedWatcher(Class<T> watcherType) {
        if (RunnerWatcher.class.isAssignableFrom(watcherType)) {
            ServiceLoader<RunnerWatcher> serviceLoader = runnerWatcherLoader;
            synchronized (serviceLoader) {
                for (RunnerWatcher watcher : runnerWatcherLoader) {
                    if (watcher.getClass() != watcherType) continue;
                    return Optional.of((Object)watcher);
                }
            }
        }
        return Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends RunListener> Optional<T> getAttachedListener(Class<T> listenerType) {
        ServiceLoader<RunListener> serviceLoader = runListenerLoader;
        synchronized (serviceLoader) {
            for (RunListener listener : runListenerLoader) {
                if (listener.getClass() != listenerType) continue;
                return Optional.of((Object)listener);
            }
        }
        return Optional.absent();
    }

    static {
        startNotified = new CopyOnWriteArraySet<String>();
        finishNotified = new CopyOnWriteArraySet<String>();
        CHILD_TO_PARENT = new ConcurrentHashMap<Object, Object>();
        NOTIFIERS = new CopyOnWriteArraySet<RunNotifier>();
        LOGGER = LoggerFactory.getLogger(Run.class);
        runnerStack = new ThreadLocal<Deque<Object>>(){

            @Override
            protected Deque<Object> initialValue() {
                return new ArrayDeque<Object>();
            }
        };
        runListenerLoader = ServiceLoader.load(RunListener.class);
        runnerWatcherLoader = ServiceLoader.load(RunnerWatcher.class);
    }
}

