/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.google.common.base.Optional;
import com.nordstrom.automation.junit.AtomicTest;
import com.nordstrom.automation.junit.JUnitWatcher;
import com.nordstrom.automation.junit.Run;
import com.nordstrom.automation.junit.RunWatcher;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunAnnouncer
extends RunListener {
    private static final ServiceLoader<RunWatcher> runWatcherLoader;
    private static final Map<Object, AtomicTest<?>> RUNNER_TO_ATOMICTEST;
    private static final Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted(Description description) throws Exception {
        LOGGER.debug("testStarted: {}", (Object)description);
        AtomicTest atomicTest = RunAnnouncer.getAtomicTestOf(description);
        ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
        synchronized (serviceLoader) {
            for (RunWatcher watcher : runWatcherLoader) {
                if (!RunAnnouncer.isSupported(watcher, atomicTest)) continue;
                watcher.testStarted(atomicTest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFinished(Description description) throws Exception {
        LOGGER.debug("testFinished: {}", (Object)description);
        AtomicTest atomicTest = RunAnnouncer.getAtomicTestOf(description);
        ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
        synchronized (serviceLoader) {
            for (RunWatcher watcher : runWatcherLoader) {
                if (!RunAnnouncer.isSupported(watcher, atomicTest)) continue;
                watcher.testFinished(atomicTest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailure(Failure failure) throws Exception {
        LOGGER.debug("testFailure: {}", (Object)failure);
        AtomicTest atomicTest = RunAnnouncer.setTestFailure(failure);
        ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
        synchronized (serviceLoader) {
            for (RunWatcher watcher : runWatcherLoader) {
                if (!RunAnnouncer.isSupported(watcher, atomicTest)) continue;
                watcher.testFailure(atomicTest, failure.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssumptionFailure(Failure failure) {
        LOGGER.debug("testAssumptionFailure: {}", (Object)failure);
        AtomicTest atomicTest = RunAnnouncer.setTestFailure(failure);
        ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
        synchronized (serviceLoader) {
            for (RunWatcher watcher : runWatcherLoader) {
                if (!RunAnnouncer.isSupported(watcher, atomicTest)) continue;
                watcher.testAssumptionFailure(atomicTest, (AssumptionViolatedException)failure.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIgnored(Description description) throws Exception {
        LOGGER.debug("testIgnored: {}", (Object)description);
        AtomicTest atomicTest = RunAnnouncer.getAtomicTestOf(description);
        ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
        synchronized (serviceLoader) {
            for (RunWatcher watcher : runWatcherLoader) {
                if (!RunAnnouncer.isSupported(watcher, atomicTest)) continue;
                watcher.testIgnored(atomicTest);
            }
        }
    }

    static <T> AtomicTest<T> newAtomicTest(Object runner, T identity) {
        AtomicTest<T> atomicTest = new AtomicTest<T>(runner, identity);
        RUNNER_TO_ATOMICTEST.put(runner, atomicTest);
        RUNNER_TO_ATOMICTEST.put(atomicTest.getDescription(), atomicTest);
        return atomicTest;
    }

    static <T> AtomicTest<T> getAtomicTestOf(Object testKey) {
        return RUNNER_TO_ATOMICTEST.get(testKey);
    }

    private static <T> AtomicTest<T> setTestFailure(Failure failure) {
        AtomicTest<T> atomicTest = RunAnnouncer.getAtomicTestOf(Run.getThreadRunner());
        if (atomicTest == null) {
            atomicTest = RunAnnouncer.getAtomicTestOf(failure.getDescription());
        }
        atomicTest.setThrowable(failure.getException());
        return atomicTest;
    }

    private static boolean isSupported(RunWatcher<?> watcher, AtomicTest<?> atomicTest) {
        return watcher.supportedType().isInstance(atomicTest.getIdentity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <W extends JUnitWatcher> Optional<W> getAttachedWatcher(Class<W> watcherType) {
        if (RunWatcher.class.isAssignableFrom(watcherType)) {
            ServiceLoader<RunWatcher> serviceLoader = runWatcherLoader;
            synchronized (serviceLoader) {
                for (RunWatcher watcher : runWatcherLoader) {
                    if (watcher.getClass() != watcherType) continue;
                    return Optional.of((Object)watcher);
                }
            }
        }
        return Optional.absent();
    }

    static {
        RUNNER_TO_ATOMICTEST = new ConcurrentHashMap();
        LOGGER = LoggerFactory.getLogger(RunAnnouncer.class);
        runWatcherLoader = ServiceLoader.load(RunWatcher.class);
    }
}

