/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.JUnitConfig;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.MutableTest;
import com.nordstrom.automation.junit.RetryHandler;
import com.nordstrom.automation.junit.Run;
import com.nordstrom.automation.junit.RunAnnouncer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;

public class RunChild {
    private static final Map<String, Boolean> notifyMap = new HashMap<String, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void intercept(@This Object runner, @SuperCall Callable<?> proxy, @Argument(value=0) Object child, @Argument(value=1) RunNotifier notifier) throws Exception {
        Run.attachRunListeners(runner, notifier);
        Map<String, Boolean> map = notifyMap;
        synchronized (map) {
            String key = runner.toString();
            if (!notifyMap.containsKey(key)) {
                notifyMap.put(key, Run.fireRunStarted(runner));
            }
        }
        try {
            Run.pushThreadRunner(runner);
            RunAnnouncer.newAtomicTest(runner, child);
            if (child instanceof FrameworkMethod) {
                boolean isIgnored;
                FrameworkMethod method = (FrameworkMethod)child;
                RunChild.applyTimeout(method);
                int count = RetryHandler.getMaxRetry(runner, method);
                boolean bl = isIgnored = null != method.getAnnotation(Ignore.class);
                if (count == 0) {
                    LifecycleHooks.callProxy(proxy);
                } else if (!isIgnored) {
                    RetryHandler.runChildWithRetry(runner, method, notifier, count);
                }
            } else {
                LifecycleHooks.callProxy(proxy);
            }
        }
        catch (NoSuchMethodException e) {
            LifecycleHooks.callProxy(proxy);
        }
        finally {
            Run.popThreadRunner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void finished() {
        Object runner = Run.getThreadRunner();
        Map<String, Boolean> map = notifyMap;
        synchronized (map) {
            if (notifyMap.get(runner.toString()).booleanValue()) {
                Run.fireRunFinished(runner);
            }
        }
    }

    private static void applyTimeout(FrameworkMethod method) {
        if (LifecycleHooks.getConfig().containsKey(JUnitConfig.JUnitSettings.TEST_TIMEOUT.key())) {
            long defaultTimeout = LifecycleHooks.getConfig().getLong(JUnitConfig.JUnitSettings.TEST_TIMEOUT.key());
            Test annotation = (Test)method.getAnnotation(Test.class);
            if (annotation != null && annotation.timeout() < defaultTimeout) {
                MutableTest.proxyFor(method.getMethod()).setTimeout(defaultTimeout);
            }
        }
    }
}

