/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.TestObjectWatcher;
import com.nordstrom.automation.junit.TimeoutUtils;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTest {
    private static final Map<Object, Object> TARGET_TO_RUNNER = new ConcurrentHashMap<Object, Object>();
    private static final Map<Object, Object> RUNNER_TO_TARGET = new ConcurrentHashMap<Object, Object>();
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateTest.class);

    @RuntimeType
    public static Object intercept(@This Object runner, @SuperCall Callable<?> proxy) throws Exception {
        Object target = LifecycleHooks.callProxy(proxy);
        TimeoutUtils.applyTestTimeout(runner, target);
        if (null == TARGET_TO_RUNNER.put(target, runner)) {
            LOGGER.debug("testObjectCreated: {}", target);
            RUNNER_TO_TARGET.put(runner, target);
            for (TestObjectWatcher watcher : LifecycleHooks.getObjectWatchers()) {
                watcher.testObjectCreated(target, runner);
            }
        }
        return target;
    }

    static Object getRunnerForTarget(Object target) {
        return TARGET_TO_RUNNER.get(target);
    }

    static Object getTargetForRunner(Object runner) {
        return RUNNER_TO_TARGET.get(runner);
    }
}

