/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.AtomicTest;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.Run;
import com.nordstrom.automation.junit.RunWatcher;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunAnnouncer
extends RunListener {
    private static final Map<Object, AtomicTest<?>> RUNNER_TO_ATOMICTEST = new ConcurrentHashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(RunAnnouncer.class);

    public void testStarted(Description description) throws Exception {
        LOGGER.debug("testStarted: {}", (Object)description);
        AtomicTest atomicTest = RunAnnouncer.newAtomicTest(description);
        for (RunWatcher<?> watcher : LifecycleHooks.getRunWatchers()) {
            if (!RunAnnouncer.isSupported(watcher, atomicTest)) continue;
            watcher.testStarted(atomicTest);
        }
    }

    public void testFinished(Description description) throws Exception {
        LOGGER.debug("testFinished: {}", (Object)description);
        AtomicTest atomicTest = RunAnnouncer.getAtomicTestOf(description);
        for (RunWatcher<?> watcher : LifecycleHooks.getRunWatchers()) {
            if (!RunAnnouncer.isSupported(watcher, atomicTest)) continue;
            watcher.testFinished(atomicTest);
        }
    }

    public void testFailure(Failure failure) throws Exception {
        LOGGER.debug("testFailure: {}", (Object)failure);
        AtomicTest atomicTest = RunAnnouncer.setTestFailure(failure);
        for (RunWatcher<?> watcher : LifecycleHooks.getRunWatchers()) {
            if (!RunAnnouncer.isSupported(watcher, atomicTest)) continue;
            watcher.testFailure(atomicTest, failure.getException());
        }
    }

    public void testAssumptionFailure(Failure failure) {
        LOGGER.debug("testAssumptionFailure: {}", (Object)failure);
        AtomicTest atomicTest = RunAnnouncer.setTestFailure(failure);
        for (RunWatcher<?> watcher : LifecycleHooks.getRunWatchers()) {
            if (!RunAnnouncer.isSupported(watcher, atomicTest)) continue;
            watcher.testAssumptionFailure(atomicTest, (AssumptionViolatedException)failure.getException());
        }
    }

    public void testIgnored(Description description) throws Exception {
        LOGGER.debug("testIgnored: {}", (Object)description);
        AtomicTest atomicTest = RunAnnouncer.getAtomicTestOf(description);
        if (atomicTest == null) {
            atomicTest = RunAnnouncer.newAtomicTest(description);
        }
        for (RunWatcher<?> watcher : LifecycleHooks.getRunWatchers()) {
            if (!RunAnnouncer.isSupported(watcher, atomicTest)) continue;
            watcher.testIgnored(atomicTest);
        }
    }

    static <T> AtomicTest<T> newAtomicTest(Object runner, T identity) {
        AtomicTest<T> atomicTest = new AtomicTest<T>(runner, identity);
        RUNNER_TO_ATOMICTEST.put(runner, atomicTest);
        return atomicTest;
    }

    static <T> AtomicTest<T> newAtomicTest(Description description) {
        AtomicTest<T> atomicTest = null;
        AtomicTest<T> original = RunAnnouncer.getAtomicTestOf(LifecycleHooks.getThreadRunner());
        if (original != null) {
            atomicTest = new AtomicTest<T>(original, description);
            RUNNER_TO_ATOMICTEST.put(description, atomicTest);
        }
        return atomicTest;
    }

    static <T> AtomicTest<T> getAtomicTestOf(Object testKey) {
        return testKey == null ? null : RUNNER_TO_ATOMICTEST.get(testKey);
    }

    private static <T> AtomicTest<T> setTestFailure(Failure failure) {
        AtomicTest<T> atomicTest = RunAnnouncer.getAtomicTestOf(Run.getThreadRunner());
        if (atomicTest == null) {
            atomicTest = RunAnnouncer.getAtomicTestOf(failure.getDescription());
        }
        if (atomicTest != null) {
            atomicTest.setThrowable(failure.getException());
        }
        return atomicTest;
    }

    private static boolean isSupported(RunWatcher<?> watcher, AtomicTest<?> atomicTest) {
        return atomicTest == null ? false : watcher.supportedType().isInstance(atomicTest.getIdentity());
    }
}

