/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.google.common.base.Function;
import com.nordstrom.automation.junit.DepthGauge;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.MethodWatcher;
import com.nordstrom.automation.junit.Run;
import com.nordstrom.common.base.UncheckedThrow;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunReflectiveCall {
    private static final Map<Object, ReflectiveCallable> CHILD_TO_CALLABLE = new ConcurrentHashMap<Object, ReflectiveCallable>();
    private static final ThreadLocal<ConcurrentMap<Integer, DepthGauge>> methodDepth;
    private static final Function<Integer, DepthGauge> newInstance;
    private static final Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RuntimeType
    public static Object intercept(@This ReflectiveCallable callable, @SuperCall Callable<?> proxy) throws Exception {
        Object child = null;
        try {
            child = LifecycleHooks.getFieldValue(callable, "this$0");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        Object runner = Run.getParentOf(child);
        if (runner == null) {
            runner = Run.getThreadRunner();
        }
        CHILD_TO_CALLABLE.put(Objects.hash(runner, child), callable);
        Object result = null;
        Throwable thrown = null;
        try {
            RunReflectiveCall.fireBeforeInvocation(runner, child, callable);
            result = LifecycleHooks.callProxy(proxy);
        }
        catch (Throwable t) {
            thrown = t;
        }
        finally {
            RunReflectiveCall.fireAfterInvocation(runner, child, callable, thrown);
        }
        if (thrown != null) {
            throw UncheckedThrow.throwUnchecked((Throwable)thrown);
        }
        return result;
    }

    static ReflectiveCallable getCallableOf(Object runner, Object child) {
        return CHILD_TO_CALLABLE.get(Objects.hash(runner, child));
    }

    private static boolean fireBeforeInvocation(Object runner, Object child, ReflectiveCallable callable) {
        DepthGauge depthGauge;
        if (runner != null && child != null && 0 == (depthGauge = LifecycleHooks.computeIfAbsent(methodDepth.get(), callable.hashCode(), newInstance)).increaseDepth()) {
            if (LOGGER.isDebugEnabled()) {
                try {
                    LOGGER.debug("beforeInvocation: {}", LifecycleHooks.invoke(runner, "describeChild", child));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            for (MethodWatcher<?> watcher : LifecycleHooks.getMethodWatchers()) {
                if (!watcher.supportedType().isInstance(child)) continue;
                watcher.beforeInvocation(runner, child, callable);
            }
            return true;
        }
        return false;
    }

    private static boolean fireAfterInvocation(Object runner, Object child, ReflectiveCallable callable, Throwable thrown) {
        DepthGauge depthGauge;
        if (runner != null && child != null && 0 == (depthGauge = LifecycleHooks.computeIfAbsent(methodDepth.get(), callable.hashCode(), newInstance)).decreaseDepth()) {
            if (LOGGER.isDebugEnabled()) {
                try {
                    LOGGER.debug("afterInvocation: {}", LifecycleHooks.invoke(runner, "describeChild", child));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            for (MethodWatcher<?> watcher : LifecycleHooks.getMethodWatchers()) {
                if (!watcher.supportedType().isInstance(child)) continue;
                watcher.afterInvocation(runner, child, callable, thrown);
            }
            return true;
        }
        return false;
    }

    static {
        LOGGER = LoggerFactory.getLogger(RunReflectiveCall.class);
        methodDepth = new ThreadLocal<ConcurrentMap<Integer, DepthGauge>>(){

            @Override
            protected ConcurrentMap<Integer, DepthGauge> initialValue() {
                return new ConcurrentHashMap<Integer, DepthGauge>();
            }
        };
        newInstance = new Function<Integer, DepthGauge>(){

            public DepthGauge apply(Integer input) {
                return new DepthGauge();
            }
        };
    }
}

