/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.automation.junit;

import com.nordstrom.automation.junit.AtomicTest;
import com.nordstrom.automation.junit.JUnitConfig;
import com.nordstrom.automation.junit.LifecycleHooks;
import com.nordstrom.automation.junit.MutableTest;
import com.nordstrom.common.base.UncheckedThrow;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

class TimeoutUtils {
    private static final Field fieldsForAnnotations;

    TimeoutUtils() {
    }

    static void applyTestTimeout(Object runner, Object target) {
        Map fieldsMap;
        long uberTimeout = -1L;
        if (LifecycleHooks.getConfig().containsKey(JUnitConfig.JUnitSettings.TIMEOUT_RULE.key())) {
            uberTimeout = LifecycleHooks.getConfig().getLong(JUnitConfig.JUnitSettings.TIMEOUT_RULE.key());
        }
        long ruleTimeout = -1L;
        TestClass testClass = LifecycleHooks.getTestClassOf(runner);
        try {
            fieldsMap = (Map)fieldsForAnnotations.get(testClass);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw UncheckedThrow.throwUnchecked((Throwable)e);
        }
        ListIterator iterator = null;
        List ruleFields = (List)fieldsMap.get(Rule.class);
        if (ruleFields != null) {
            iterator = ruleFields.listIterator();
            while (iterator.hasNext()) {
                FrameworkField ruleField = (FrameworkField)iterator.next();
                if (!Timeout.class.isAssignableFrom(ruleField.getType())) continue;
                try {
                    ruleTimeout = (Long)LifecycleHooks.invoke(ruleField.get(target), "getTimeout", new Object[]{TimeUnit.MILLISECONDS});
                    break;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    UncheckedThrow.throwUnchecked((Throwable)e);
                }
            }
        }
        AtomicTest atomicTest = LifecycleHooks.getAtomicTestOf(runner);
        FrameworkMethod identity = (FrameworkMethod)atomicTest.getIdentity();
        if (uberTimeout == 0L || ruleTimeout == 0L) {
            MutableTest.proxyFor(identity.getMethod()).setTimeout(0L);
        } else {
            Test annotation;
            long metaTimeout;
            long testTimeout = -1L;
            if (LifecycleHooks.getConfig().containsKey(JUnitConfig.JUnitSettings.TEST_TIMEOUT.key())) {
                testTimeout = LifecycleHooks.getConfig().getLong(JUnitConfig.JUnitSettings.TEST_TIMEOUT.key());
            }
            if (testTimeout > (metaTimeout = (annotation = (Test)identity.getAnnotation(Test.class)).timeout())) {
                MutableTest.proxyFor(identity.getMethod()).setTimeout(testTimeout);
            }
        }
    }

    static void applyRuleTimeout(Object runner, List<TestRule> testRules) {
        long timeout;
        AtomicTest atomicTest = LifecycleHooks.getAtomicTestOf(runner);
        FrameworkMethod identity = (FrameworkMethod)atomicTest.getIdentity();
        Test annotation = (Test)identity.getAnnotation(Test.class);
        long metaTimeout = annotation.timeout();
        long uberTimeout = -1L;
        if (LifecycleHooks.getConfig().containsKey(JUnitConfig.JUnitSettings.TIMEOUT_RULE.key())) {
            uberTimeout = LifecycleHooks.getConfig().getLong(JUnitConfig.JUnitSettings.TIMEOUT_RULE.key());
        }
        int ruleIndex = -1;
        long ruleTimeout = -1L;
        for (int i = 0; i < testRules.size(); ++i) {
            TestRule testRule = testRules.get(i);
            if (!(testRule instanceof Timeout)) continue;
            ruleIndex = i;
            ruleTimeout = (Long)LifecycleHooks.invoke(testRule, "getTimeout", new Object[]{TimeUnit.MILLISECONDS});
            break;
        }
        boolean disableTimeout = uberTimeout == 0L || ruleTimeout == 0L;
        long l = timeout = disableTimeout ? 0L : Collections.max(Arrays.asList(metaTimeout, uberTimeout, ruleTimeout));
        if (ruleIndex != -1) {
            if (ruleTimeout != timeout) {
                testRules.set(ruleIndex, (TestRule)Timeout.millis((long)timeout));
            }
        } else if (uberTimeout != -1L) {
            testRules.add((TestRule)Timeout.millis((long)timeout));
        }
    }

    static {
        try {
            fieldsForAnnotations = TestClass.class.getDeclaredField("fieldsForAnnotations");
            fieldsForAnnotations.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw UncheckedThrow.throwUnchecked((Throwable)e);
        }
    }
}

